/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.caching;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import org.squashtest.tm.plugin.bugtracker.redmine3.caching.RedmineBugTrackerAndProject;
import org.squashtest.tm.plugin.bugtracker.redmine3.caching.RedmineCachedValues;
import org.squashtest.tm.plugin.bugtracker.redmine3.caching.RedmineCompositeCacheKey;

public class RedmineValueCacheQueue {
    private final Set<RedmineBugTrackerAndProject> seen = new HashSet<RedmineBugTrackerAndProject>();
    private final PriorityQueue<RedmineBugTrackerAndProject> queue;
    private final Object lock = new Object();

    public RedmineValueCacheQueue(Map<RedmineCompositeCacheKey, RedmineCachedValues> cacheMap) {
        this.queue = new PriorityQueue<RedmineBugTrackerAndProject>(Comparator.comparingInt(o -> this.priority((RedmineBugTrackerAndProject)o, cacheMap)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.size();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RedmineBugTrackerAndProject redmineBugTrackerAndProject) {
        Object object = this.lock;
        synchronized (object) {
            return this.seen.contains(redmineBugTrackerAndProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(RedmineBugTrackerAndProject redmineBtAndProject) {
        Object object = this.lock;
        synchronized (object) {
            if (this.seen.add(redmineBtAndProject)) {
                this.queue.offer(redmineBtAndProject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<RedmineBugTrackerAndProject> poll() {
        Object object = this.lock;
        synchronized (object) {
            RedmineBugTrackerAndProject item = this.queue.poll();
            if (item != null) {
                this.seen.remove(item);
            }
            return Optional.ofNullable(item);
        }
    }

    private int priority(RedmineBugTrackerAndProject item, Map<RedmineCompositeCacheKey, RedmineCachedValues> cacheMap) {
        RedmineCompositeCacheKey key = new RedmineCompositeCacheKey(item.bugTracker().getId(), item.project().getName());
        RedmineCachedValues values = cacheMap.get(key);
        if (values == null) {
            return 1;
        }
        if (values.hasCacheError()) {
            return 0;
        }
        return 2;
    }
}

