/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.scm.git.internal;

import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.scm.git.internal.BasicGitConnector;
import org.squashtest.tm.plugin.scm.git.internal.GitClient;
import org.squashtest.tm.plugin.scm.git.internal.exception.GitPluginException;
import org.squashtest.tm.plugin.scm.git.internal.scheduling.ScheduledTaskManagerService;

@Component
@Scope(value="prototype")
public class GitConnector
extends BasicGitConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitConnector.class);
    private static final String SQUASH_TM_COMMITTER_NAME = "SquashTM";
    private static final String SQUASH_TM_DEFAULT_COMMIT_MESSAGE = "Synchronize SquashTM repository";
    private static final String SLASH = "/";
    private static final String DOT_GIT = ".git";
    private static final int DEFAULT_DELAY_DURATION = 60;
    private static final int PUSH_ATTEMPTS_LIMIT = 10;
    @Inject
    private MessageSource i18nHelper;
    private ScmRepository scmRepository;
    @Inject
    private GitClient client;
    @Inject
    private ScheduledTaskManagerService scheduler;

    public void createRepository(Credentials credentials) throws GitPluginException, IOException {
        String remoteRepositoryUrl = GitConnector.getCheckedRemoteUrl(this.scmRepository.getScmServer().getUrl() + SLASH + this.scmRepository.getName());
        this.scmRepository.doWithLock(() -> {
            this.client.createRepository(remoteRepositoryUrl, this.scmRepository.getRepositoryPath(), this.scmRepository.getWorkingBranch(), credentials);
            return null;
        });
        this.client.closeRepository();
    }

    private static String getCheckedRemoteUrl(String remoteRepositoryUrl) {
        try {
            remoteRepositoryUrl = new URI(remoteRepositoryUrl).toString();
        }
        catch (URISyntaxException ex) {
            LOGGER.debug(ex.getMessage(), (Throwable)ex);
            remoteRepositoryUrl = Path.of(remoteRepositoryUrl, new String[0]).toString();
        }
        return remoteRepositoryUrl.endsWith(DOT_GIT) ? remoteRepositoryUrl : remoteRepositoryUrl.concat(DOT_GIT);
    }

    public void prepareRepository(Credentials credentials) throws IOException {
        this.client.initClientIfNeeded(this.scmRepository.getRepositoryPath());
        this.scheduler.cancelScheduledTask(this.scmRepository.getId());
        this.scmRepository.doWithLock(() -> {
            this.client.testCredentials(credentials);
            this.client.prepareRepository(this.scmRepository.getWorkingBranch(), this.scmRepository.getScmServer().getCommitterMail(), credentials);
            return null;
        });
        this.client.closeRepository();
    }

    private String getMessage(String i18nKey, Object[] args) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.i18nHelper.getMessage(i18nKey, args, locale);
    }

    public void setScmRepository(ScmRepository scmRepository) {
        this.scmRepository = scmRepository;
    }

    public void closeRepository() {
        this.client.closeRepository();
    }

    public void testCredentials(Credentials credentials) {
        this.client.initClientIfNeeded(this.scmRepository.getRepositoryPath());
        this.client.testCredentials(credentials);
    }

    public void synchronize(Credentials credentials) throws IOException {
        this.client.initClientIfNeeded(this.scmRepository.getRepositoryPath());
        this.scmRepository.doWithLock(() -> {
            this.client.testCredentials(credentials);
            this.addAllToIndexAndScheduleCommitPush(SQUASH_TM_COMMITTER_NAME, SQUASH_TM_DEFAULT_COMMIT_MESSAGE, credentials);
            return null;
        });
        this.client.closeRepository();
    }

    private void addAllToIndexAndScheduleCommitPush(String committerName, String commitMessage, Credentials credentials) {
        CommitPushTask commitPushTask = new CommitPushTask(committerName, commitMessage, credentials);
        this.addAllToIndex(commitPushTask);
    }

    private void addAllToIndex(Callable commitPushTask) {
        this.client.stageFilesToIndex(Path.of(this.scmRepository.getWorkingFolderPath(), new String[0]));
        this.scheduler.scheduleOneTask(this.scmRepository.getId(), commitPushTask, 60);
    }

    static /* synthetic */ Logger access$0() {
        return LOGGER;
    }

    static /* synthetic */ ScmRepository access$1(GitConnector gitConnector) {
        return gitConnector.scmRepository;
    }

    static /* synthetic */ GitClient access$2(GitConnector gitConnector) {
        return gitConnector.client;
    }

    private class CommitPushTask
    implements Callable {
        private String mCommitterName;
        private String mCommitMessage;
        private Credentials mCredentials;

        public CommitPushTask(String committerName, String commitMessage, Credentials credentials) {
            this.mCommitterName = committerName;
            this.mCommitMessage = commitMessage;
            this.mCredentials = credentials;
        }

        public Boolean call() {
            try {
                boolean result = (Boolean)GitConnector.this.scmRepository.doWithLock(() -> {
                    LOGGER.trace("Committing and Pushing in Repository: " + GitConnector.this.scmRepository.getName());
                    GitConnector.this.client.commit(this.mCommitterName, GitConnector.this.scmRepository.getScmServer().getCommitterMail(), this.mCommitMessage);
                    boolean success = GitConnector.this.client.safePush(this.mCredentials);
                    int attemptsNbr = 1;
                    while (!success && attemptsNbr < 10) {
                        LOGGER.debug("Push did not happen. Try rebasing and continuing. Attempt  n\u00b0" + attemptsNbr + ".");
                        GitConnector.this.client.rebase();
                        success = GitConnector.this.client.safePush(this.mCredentials);
                        ++attemptsNbr;
                    }
                    return success;
                });
                if (!result) {
                    throw new GitPluginException(GitConnector.this.getMessage("error.message.pushFailToRepository", new Object[]{GitConnector.this.scmRepository.getName()}));
                }
                LOGGER.debug("Successfully pushed file(s) in Repository {}.", (Object)GitConnector.this.scmRepository.getName());
                GitConnector.this.closeRepository();
                return result;
            }
            catch (IOException | GitPluginException ex) {
                LOGGER.error(((Throwable)ex).getMessage(), (Throwable)ex);
                throw new GitPluginException(((Throwable)ex).getMessage(), (Throwable)ex);
            }
        }
    }
}

