/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web.exceptionhandler;

import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.core.foundation.exception.EntityDoesNotExistException;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.plugin.rest.core.exception.FeatureDisabledException;
import org.squashtest.tm.plugin.rest.core.exception.IllegalPremiumFeatureAccessException;
import org.squashtest.tm.plugin.rest.core.web.IRestController;
import org.squashtest.tm.plugin.rest.core.web.exceptionhandler.response.DetailedJsonError;
import org.squashtest.tm.plugin.rest.core.web.exceptionhandler.response.JsonError;

@ControllerAdvice(assignableTypes={IRestController.class})
public class RestApiGenericExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestApiGenericExceptionHandler.class);
    private static final String UNEXPECTED_ERROR_OCCURRED = "An unexpected error occurred.";
    private static final String LOG_FORMAT = "{}: {}";
    private static final Class<?>[] NOT_FOUND_EXCEPTIONS = new Class[]{NoResultException.class, EntityNotFoundException.class};

    @ExceptionHandler(value={FeatureDisabledException.class})
    public ResponseEntity<JsonError> handleFeatureUnavailableException(FeatureDisabledException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)new DetailedJsonError(HttpStatus.FORBIDDEN.value(), ex.getErrorName(), ex.getMessage()));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<JsonError> handleInvalidJsonBody(HttpMessageNotReadableException ex) {
        LOGGER.error(LOG_FORMAT, (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        return this.buildDetailedResponse(HttpStatus.BAD_REQUEST, "Invalid JSON.");
    }

    @ExceptionHandler
    public ResponseEntity<JsonError> handleInvalidJsonBody(MethodArgumentTypeMismatchException ex) {
        LOGGER.error(LOG_FORMAT, (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        return this.buildDetailedResponse(HttpStatus.BAD_REQUEST, "Invalid type for argument #" + (ex.getParameter().getParameterIndex() + 1) + " ('" + ex.getPropertyName() + "').");
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<JsonError> handleBadRequest(Throwable ex) {
        LOGGER.error(LOG_FORMAT, (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        return this.buildDetailedResponse(HttpStatus.BAD_REQUEST, ex);
    }

    @ExceptionHandler(value={NoResultException.class, EntityNotFoundException.class, EntityDoesNotExistException.class})
    ResponseEntity<JsonError> handleNotFound(Throwable ex) {
        LOGGER.error(LOG_FORMAT, (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        return this.buildDetailedResponse(HttpStatus.NOT_FOUND, ex);
    }

    @ExceptionHandler
    ResponseEntity<JsonError> handleAccessDenied(AccessDeniedException ex) {
        LOGGER.error(LOG_FORMAT, (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        return this.buildOpaqueResponse(HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler
    ResponseEntity<JsonError> handleActionException(ActionException ex) {
        LOGGER.error(LOG_FORMAT, (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        return this.buildDetailedResponse(HttpStatus.PRECONDITION_FAILED, (Throwable)ex);
    }

    @ExceptionHandler
    ResponseEntity<JsonError> handleDomainException(DomainException ex) {
        LOGGER.error(LOG_FORMAT, (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        return this.buildDetailedResponse(HttpStatus.PRECONDITION_FAILED, (Throwable)ex);
    }

    @ExceptionHandler(value={RuntimeException.class})
    ResponseEntity<JsonError> catchAll(Exception unqualifiedException) {
        LOGGER.debug("wrapped-exception handler invoked, attempting to resolve the root exception");
        Throwable root = this.findRootException(unqualifiedException);
        if (RestApiGenericExceptionHandler.isNotFoundException(root)) {
            return this.handleNotFound(root);
        }
        return this.handleAnyException((Exception)root);
    }

    @ExceptionHandler(value={IllegalPremiumFeatureAccessException.class})
    public ResponseEntity<DetailedJsonError> handleIllegalPremiumFeatureAccessException(IllegalPremiumFeatureAccessException ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)new DetailedJsonError(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ex.getMessage()));
    }

    private static boolean isNotFoundException(Throwable root) {
        Class<?>[] classArray = NOT_FOUND_EXCEPTIONS;
        int n = NOT_FOUND_EXCEPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> exception = classArray[n2];
            if (exception.isAssignableFrom(root.getClass())) {
                return true;
            }
            ++n2;
        }
        return RestApiGenericExceptionHandler.hasHttpStatusNotFound(root);
    }

    private static boolean hasHttpStatusNotFound(Throwable root) {
        try {
            Method getStatusMethod = root.getClass().getMethod("getHttpStatus", new Class[0]);
            Object statusObj = getStatusMethod.invoke((Object)root, new Object[0]);
            if (statusObj instanceof Integer) {
                Integer status = (Integer)statusObj;
                return status.intValue() == HttpStatus.NOT_FOUND.value();
            }
            if (statusObj instanceof HttpStatus) {
                HttpStatus httpStatus = (HttpStatus)statusObj;
                return httpStatus == HttpStatus.NOT_FOUND;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
        return false;
    }

    private ResponseEntity<JsonError> handleAnyException(Exception ex) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("resolving exception '%s' with the catch-all handler".formatted(ex.getClass().getName()), (Throwable)ex);
        }
        LOGGER.error(ex.getMessage(), (Throwable)ex);
        return this.buildDetailedResponse(HttpStatus.INTERNAL_SERVER_ERROR, UNEXPECTED_ERROR_OCCURRED);
    }

    private Throwable findRootException(Exception caught) {
        Throwable root = caught;
        while (root.getCause() != null && root.getCause() != root) {
            root = root.getCause();
        }
        return root;
    }

    private ResponseEntity<JsonError> buildDetailedResponse(HttpStatus status, String message) {
        return ResponseEntity.status((HttpStatusCode)status).body((Object)new DetailedJsonError(status.value(), status.getReasonPhrase(), message));
    }

    private ResponseEntity<JsonError> buildDetailedResponse(HttpStatus status, Throwable exception) {
        return ResponseEntity.status((HttpStatusCode)status).body((Object)new DetailedJsonError(status.value(), status.getReasonPhrase(), exception.getMessage()));
    }

    private ResponseEntity<JsonError> buildOpaqueResponse(HttpStatus status) {
        return ResponseEntity.status((HttpStatusCode)status).body((Object)new JsonError(status.value(), status.getReasonPhrase()));
    }
}

