/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.squashtest.tm.plugin.rest.core.jackson.ChainConverter;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializeChainConverter;
import org.squashtest.tm.plugin.rest.core.jackson.SerializeChainConverter;

public class StackableAnnotationIntrospector
extends NopAnnotationIntrospector {
    public Version version() {
        return null;
    }

    public void findAndAddVirtualProperties(MapperConfig<?> config, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
        List<JsonAppend> allAppends = this.findAllJsonAppend(config, ac);
        if (allAppends.isEmpty()) {
            return;
        }
        Set<PropertyName> propertyNames = this.getPropertyNames(properties);
        for (JsonAppend ann : allAppends) {
            boolean prepend = ann.prepend();
            JsonAppend.Prop[] props = ann.props();
            int i = 0;
            int len = props.length;
            while (i < len) {
                JsonAppend.Prop prop = props[i];
                PropertyName name = this._propertyName(prop.name(), prop.namespace());
                if (!propertyNames.contains(name)) {
                    BeanPropertyWriter bpw = this._constructVirtualProperty(props[i], config, ac);
                    if (prepend) {
                        properties.add(i, bpw);
                    } else {
                        properties.add(bpw);
                    }
                }
                ++i;
            }
        }
    }

    public Object findSerializationConverter(Annotated a) {
        SerializeChainConverter ann = (SerializeChainConverter)this._findAnnotation(a, SerializeChainConverter.class);
        if (ann == null || ann.converters().length == 0) {
            return null;
        }
        return ChainConverter.SerialChainConverter.class;
    }

    public Object findSerializationContentConverter(AnnotatedMember a) {
        SerializeChainConverter ann = (SerializeChainConverter)this._findAnnotation((Annotated)a, SerializeChainConverter.class);
        if (ann == null || ann.contentConverters().length == 0) {
            return null;
        }
        return ChainConverter.SerialContentChainConverter.class;
    }

    public Object findDeserializationConverter(Annotated a) {
        DeserializeChainConverter ann = (DeserializeChainConverter)this._findAnnotation(a, DeserializeChainConverter.class);
        if (ann == null || ann.converters().length == 0) {
            return null;
        }
        return ChainConverter.DeserialChainConverter.class;
    }

    public Object findDeserializationContentConverter(AnnotatedMember a) {
        DeserializeChainConverter ann = (DeserializeChainConverter)this._findAnnotation((Annotated)a, DeserializeChainConverter.class);
        if (ann == null || ann.contentConverters().length == 0) {
            return null;
        }
        return ChainConverter.DeserialContentChainConverter.class;
    }

    private List<JsonAppend> findAllJsonAppend(MapperConfig<?> config, AnnotatedClass ac) {
        Class underIntrospection = ac.getAnnotated();
        Class mixin = config.findMixInClassFor(underIntrospection);
        if (mixin == null) {
            return Collections.emptyList();
        }
        ArrayList<JsonAppend> appends = new ArrayList<JsonAppend>();
        for (Class parent : ClassUtil.findSuperClasses((Class)mixin, (Class)underIntrospection, (boolean)false)) {
            Annotation[] annotationArray = ClassUtil.findClassAnnotations((Class)parent);
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation an = annotationArray[n2];
                if (an instanceof JsonAppend) {
                    JsonAppend append = (JsonAppend)an;
                    appends.add(append);
                }
                ++n2;
            }
        }
        return appends;
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Prop prop, MapperConfig<?> config, AnnotatedClass ac) {
        VirtualBeanPropertyWriter bpw;
        PropertyMetadata metadata = prop.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        PropertyName propName = this._propertyName(prop.name(), prop.namespace());
        JavaType type = config.constructType(prop.type());
        VirtualAnnotatedMember member = new VirtualAnnotatedMember((TypeResolutionContext)ac, ac.getRawType(), propName.getSimpleName(), type);
        SimpleBeanPropertyDefinition propDef = SimpleBeanPropertyDefinition.construct(config, (AnnotatedMember)member, (PropertyName)propName, (PropertyMetadata)metadata, (JsonInclude.Include)prop.include());
        Class implClass = prop.value();
        HandlerInstantiator hi = config.getHandlerInstantiator();
        VirtualBeanPropertyWriter virtualBeanPropertyWriter = bpw = hi == null ? null : hi.virtualPropertyWriterInstance(config, implClass);
        if (bpw == null) {
            bpw = (VirtualBeanPropertyWriter)ClassUtil.createInstance((Class)implClass, (boolean)config.canOverrideAccessModifiers());
        }
        return bpw.withConfig(config, ac, (BeanPropertyDefinition)propDef, type);
    }

    protected PropertyName _propertyName(String localName, String namespace) {
        if (localName.isEmpty()) {
            return PropertyName.USE_DEFAULT;
        }
        if (namespace == null || namespace.isEmpty()) {
            return PropertyName.construct((String)localName);
        }
        return PropertyName.construct((String)localName, (String)namespace);
    }

    private Set<PropertyName> getPropertyNames(List<BeanPropertyWriter> writers) {
        HashSet<PropertyName> names = new HashSet<PropertyName>();
        for (BeanPropertyWriter writer : writers) {
            names.add(writer.getFullName());
        }
        return names;
    }
}

