/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.plugin.rest.core.exception.ProgrammingError;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializeChainConverter;
import org.squashtest.tm.plugin.rest.core.jackson.SerializeChainConverter;

public abstract class ChainConverter<IN, OUT>
extends StdConverter<IN, OUT> {
    private static final Class<? extends Converter>[] EMPTY_CONVERTERS = new Class[0];
    private List<Converter> chain = new ArrayList<Converter>();

    public ChainConverter() {
    }

    public ChainConverter(List<Converter> converters) {
        this.chain = converters;
    }

    public void addConverter(Converter converter) {
        this.chain.add(converter);
    }

    public abstract Class<? extends Converter>[] convertersFrom(SerializeChainConverter var1, DeserializeChainConverter var2);

    public OUT convert(IN value) {
        Object res = value;
        for (Converter converter : this.chain) {
            res = converter.convert(res);
        }
        return (OUT)res;
    }

    public JavaType getInputType(TypeFactory typeFactory) {
        this.checkIsWellFormed();
        Converter firstConv = this.chain.get(0);
        return this._findConverterType(firstConv, typeFactory).containedType(0);
    }

    public JavaType getOutputType(TypeFactory typeFactory) {
        this.checkIsWellFormed();
        Converter lastConv = this.chain.get(this.chain.size() - 1);
        return this._findConverterType(lastConv, typeFactory).containedType(1);
    }

    protected JavaType _findConverterType(Converter conv, TypeFactory tf) {
        JavaType thisType = tf.constructType(conv.getClass());
        JavaType convType = thisType.findSuperType(Converter.class);
        if (convType == null || convType.containedTypeCount() < 2) {
            throw new IllegalStateException("Can not find OUT type parameter for Converter of type " + ((Object)((Object)this)).getClass().getName());
        }
        return convType;
    }

    public void checkIsWellFormed() {
        if (this.chain.isEmpty()) {
            throw new ProgrammingError("declared an empty ChainConverter");
        }
    }

    public static final class DeserialChainConverter<IN, OUT>
    extends ChainConverter<IN, OUT> {
        @Override
        public Class<? extends Converter>[] convertersFrom(SerializeChainConverter ser, DeserializeChainConverter deser) {
            return deser != null ? deser.converters() : EMPTY_CONVERTERS;
        }
    }

    public static final class DeserialContentChainConverter<IN, OUT>
    extends ChainConverter<IN, OUT> {
        @Override
        public Class<? extends Converter>[] convertersFrom(SerializeChainConverter ser, DeserializeChainConverter deser) {
            return deser != null ? deser.contentConverters() : EMPTY_CONVERTERS;
        }
    }

    public static final class SerialChainConverter<IN, OUT>
    extends ChainConverter<IN, OUT> {
        @Override
        public Class<? extends Converter>[] convertersFrom(SerializeChainConverter ser, DeserializeChainConverter deser) {
            return ser != null ? ser.converters() : EMPTY_CONVERTERS;
        }
    }

    public static final class SerialContentChainConverter<IN, OUT>
    extends ChainConverter<IN, OUT> {
        @Override
        public Class<? extends Converter>[] convertersFrom(SerializeChainConverter ser, DeserializeChainConverter deser) {
            return ser != null ? ser.contentConverters() : EMPTY_CONVERTERS;
        }
    }
}

