/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.squashtest.tm.plugin.rest.core.exception.UnbalancedFilterExpressionException;
import org.squashtest.tm.plugin.rest.core.jackson.FilterExpression;
import org.squashtest.tm.plugin.rest.core.jackson.FilterExpressionBuilder;

@NotThreadSafe
public class BaseDynamicFilter {
    private static final Set<String> ALWAYS_INCLUDE = new HashSet<String>();
    private static final String STAR = "*";
    private FilterExpression rootPointer;
    private FilterExpression pointer;
    private Deque<FilterExpression> pointerStack = new LinkedList<FilterExpression>();
    private String currentProperty;
    private Set<String> alwaysInclude = ALWAYS_INCLUDE;

    static {
        ALWAYS_INCLUDE.add("_type");
        ALWAYS_INCLUDE.add("id");
    }

    BaseDynamicFilter() {
        this("");
    }

    public BaseDynamicFilter(String filterExpression) {
        try {
            this.rootPointer = FilterExpressionBuilder.from(filterExpression);
        }
        catch (UnbalancedFilterExpressionException unbalancedFilterExpressionException) {
            throw new UnbalancedFilterExpressionException("unbalanced filter expression : " + filterExpression);
        }
        this.pointer = this.rootPointer;
    }

    public BaseDynamicFilter(FilterExpression objExpression) {
        this.pointer = this.rootPointer = objExpression;
    }

    void defineMandatoryProperties(String ... properties) {
        this.alwaysInclude = new HashSet<String>(properties.length);
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String ppt = stringArray[n2];
            this.alwaysInclude.add(ppt);
            ++n2;
        }
    }

    FilterExpression getPointer() {
        return this.pointer;
    }

    void setCurrentProperty(String current) {
        this.currentProperty = current;
    }

    public boolean isRootObject() {
        return this.pointerStack.isEmpty();
    }

    boolean include(String pptName) {
        String savePpt = this.currentProperty;
        this.currentProperty = pptName;
        boolean res = this.include();
        this.currentProperty = savePpt;
        return res;
    }

    BaseDynamicFilter forCurrentBean() {
        return new BaseDynamicFilter(this.pointer);
    }

    private boolean filterIsEmpty() {
        return this.pointer == null || this.pointer.isEmpty();
    }

    private boolean isMandatory() {
        return this.alwaysInclude.contains(this.currentProperty);
    }

    private boolean isPropertyDefined() {
        return this.pointer.containsKey(this.currentProperty);
    }

    private boolean usesStarAndNotDisabled() {
        return this.pointer.containsKey(STAR) && !this.pointer.containsKey("-" + this.currentProperty);
    }

    boolean include() {
        boolean shouldInclude = false;
        if (this.isMandatory()) {
            shouldInclude = true;
        } else if (this.filterIsEmpty()) {
            if (this.isRootObject()) {
                shouldInclude = true;
            }
        } else if (this.isPropertyDefined() || this.usesStarAndNotDisabled()) {
            shouldInclude = true;
        }
        return shouldInclude;
    }

    void advancePointer() {
        this.pointerStack.push(this.pointer);
        if (this.pointer != null) {
            this.pointer = (FilterExpression)this.pointer.get(this.currentProperty);
        }
    }

    void resetPointer() {
        this.pointer = this.pointerStack.pop();
    }
}

