/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.plugin.rest.admin.jackson.model.LogsInfoDto;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.system.LogFileDownloadService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestLogController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestLogController.class);
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private static final String DOWNLOAD_ERROR_MESSAGE = "Error downloading log file";
    private final LogFileDownloadService logFileDownloadService;

    public RestLogController(LogFileDownloadService logFileDownloadService) {
        this.logFileDownloadService = logFileDownloadService;
    }

    @GetMapping(value={"/logs"})
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public ResponseEntity<EntityModel<LogsInfoDto>> getLogs() {
        List logFileNames = this.logFileDownloadService.getAllLogFileNames();
        EntityModel res = EntityModel.of((Object)new LogsInfoDto(logFileNames));
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/logs/{logFileName}/download"}, produces={"text/plain"})
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public ResponseEntity<StreamingResponseBody> downloadLogFile(@PathVariable(value="logFileName") String logFileName) {
        try {
            File logfile = this.logFileDownloadService.getLogFile(logFileName);
            StreamingResponseBody stream = outputStream -> {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (FileInputStream inputStream = new FileInputStream(logfile);){
                        ((InputStream)inputStream).transferTo(outputStream);
                        outputStream.flush();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error during file streaming: {}", new Object[]{logFileName, e});
                    throw e;
                }
            };
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).contentLength(logfile.length()).header("Content-Disposition", new String[]{ATTACHMENT_FILENAME + logFileName})).body((Object)stream);
        }
        catch (IOException e) {
            LOGGER.error(DOWNLOAD_ERROR_MESSAGE, new Object[]{logFileName, e});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        catch (IllegalStateException e) {
            LOGGER.error(DOWNLOAD_ERROR_MESSAGE, new Object[]{logFileName, e});
            return ResponseEntity.badRequest().build();
        }
    }
}

