/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.plugin.rest.admin.jackson.model.InfoListDto;
import org.squashtest.tm.plugin.rest.admin.service.RestInfoListService;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController(value=InfoList.class)
@UseDefaultRestApiConfiguration
public class RestInfoListController
extends BaseRestController {
    @Inject
    RestInfoListService restInfoListService;

    @GetMapping(value={"/info-lists"})
    @DynamicFilterExpression(value="*,items[*,-info_list]")
    public ResponseEntity<PagedModel<EntityModel<InfoList>>> findAllInfoList(Pageable pageable) {
        Page<InfoList> infoListPage = this.restInfoListService.findAllUserLists(pageable);
        PagedModel res = this.toPagedModel(infoListPage);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/info-lists/{id}"})
    @EntityGetter
    @DynamicFilterExpression(value="*,items[*,-info_list]")
    public ResponseEntity<EntityModel<InfoList>> findInfoListById(@PathVariable(value="id") Long infoListId) {
        InfoList iList = this.restInfoListService.findById(infoListId);
        EntityModel res = this.toEntityModel((Identified)iList);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/info-lists"})
    @DynamicFilterExpression(value="*,-last_modified_on,-last_modified_by,items[*,-info_list]")
    public ResponseEntity<EntityModel<InfoList>> createInfoList(@RequestBody InfoListDto infoListDto) {
        InfoList infoList = infoListDto.dtoToInfoList();
        InfoList list = this.restInfoListService.createInfoList(infoList);
        EntityModel res = this.toEntityModel((Identified)list);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/info-lists/{id}"})
    @DynamicFilterExpression(value="*,items[*,-info_list]")
    public ResponseEntity<EntityModel<InfoList>> updateInfoList(@PathVariable(value="id") Long infoListId, @RequestBody InfoListDto infoListDto) {
        InfoList updatedInfoList = this.restInfoListService.updateInfolist(infoListId, infoListDto);
        EntityModel res = this.toEntityModel((Identified)updatedInfoList);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/info-lists/{ids}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<String> deleteInfoListById(@PathVariable(value="ids") List<Long> infoListIds) {
        this.restInfoListService.deleteSeveralInfolist(infoListIds);
        return ResponseEntity.noContent().build();
    }
}

