/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.BugzillaXmlrcpClient;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Bug;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaField;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Component;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Product;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.CacheService;

public class FieldService {
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String VALUES = "values";
    private final CacheService cache;
    private final BugzillaXmlrcpClient client;

    public FieldService(CacheService cacheService, BugzillaXmlrcpClient client) {
        this.cache = cacheService;
        this.client = client;
    }

    private void addPossibleValues(BugzillaField custom, Map<String, Object> values) {
        if (values.get(VALUES) != null) {
            Object[] possibleValues;
            ArrayList<Object> listPossibleValues = new ArrayList<Object>();
            Object[] objectArray = possibleValues = (Object[])values.get(VALUES);
            int n = possibleValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Map map = (Map)o;
                listPossibleValues.add(map.get(NAME));
                ++n2;
            }
            custom.setPossibleValues(listPossibleValues);
        }
    }

    private void addVisibilityValues(BugzillaField custom, Map<String, Object> values) {
        if (values.get("visibility_values") != null) {
            Object[] visibilityValues;
            ArrayList<String> listVisibilityValues = new ArrayList<String>();
            Object[] objectArray = visibilityValues = (Object[])values.get("visibility_values");
            int n = visibilityValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                listVisibilityValues.add((String)o);
                ++n2;
            }
            custom.setVisibilityValues(listVisibilityValues);
        }
    }

    public BugzillaField createFieldWithPossibleValues(Map<String, Object> values) {
        BugzillaField bzField = this.createField(values);
        this.addPossibleValues(bzField, values);
        this.addVisibilityValues(bzField, values);
        return bzField;
    }

    private BugzillaField createField(Map<String, Object> field) {
        BugzillaField bzField = new BugzillaField();
        bzField.setName((String)field.get(NAME));
        bzField.setLabel((String)field.get("display_name"));
        bzField.setMandatory((Boolean)field.get("is_mandatory"));
        bzField.setType((Integer)field.get("type"));
        bzField.setVisibilityField((String)field.get("visibility_field"));
        bzField.setCustom((Boolean)field.get("is_custom"));
        return bzField;
    }

    public List<Map<String, Object>> getPossibleValuesOfField(List<Map<String, Object>> fields, String fieldName) {
        return fields.stream().filter(field -> field.get(NAME).equals(fieldName)).map(field -> Arrays.stream((Object[])field.get(VALUES)).map(value -> (Map)value).collect(Collectors.toList())).findFirst().orElseThrow(() -> new IllegalArgumentException("Found no field with name " + fieldName));
    }

    private List<BugzillaField> createAllNonCustomField(Map<String, Object> product) throws BugzillaXmlrpcException {
        return this.cache.getNonCustomFields().stream().map(field -> {
            String fieldName = (String)field.get(NAME);
            if ("version".equals(fieldName) || "target_milestone".equals(fieldName)) {
                return this.createVersionOrMilestoneField(product, (Map<String, Object>)field);
            }
            return this.createFieldWithPossibleValues((Map<String, Object>)field);
        }).collect(Collectors.toList());
    }

    private BugzillaField createVersionOrMilestoneField(Map<String, Object> product, Map<String, Object> field) {
        BugzillaField bzField = this.createField(field);
        this.addPossibleValuesForVersionOrMilestone(bzField, product);
        this.addVisibilityValues(bzField, field);
        return bzField;
    }

    private void addPossibleValuesForVersionOrMilestone(BugzillaField bzField, Map<String, Object> mapProduct) {
        List valuesList;
        if ("version".equals(bzField.getName())) {
            valuesList = Arrays.stream((Object[])mapProduct.get("versions")).map(version -> (Map)version).collect(Collectors.toList());
        } else if ("target_milestone".equals(bzField.getName())) {
            valuesList = Arrays.stream((Object[])mapProduct.get("milestones")).map(version -> (Map)version).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("You should not be there ! It's only for version and milestone");
        }
        List<Object> possibleValues = valuesList.stream().map(value -> value.get(NAME)).collect(Collectors.toList());
        bzField.setPossibleValues(possibleValues);
    }

    public Product createProductFromProductMap(Map<String, Object> product) throws BugzillaXmlrpcException {
        Product newProduct = new Product();
        newProduct.setId((Integer)product.get(ID));
        newProduct.setName((String)product.get(NAME));
        newProduct.setComponents(this.createListeComponent(product, newProduct));
        return newProduct;
    }

    private List<Component> createListeComponent(Map<String, Object> productAsMap, Product product) throws BugzillaXmlrpcException {
        Object[] components = (Object[])productAsMap.get("components");
        ArrayList<Component> listeComponent = new ArrayList<Component>();
        List<BugzillaField> customFields = this.client.getCustomFields();
        List<BugzillaField> nonCustomFields = this.createAllNonCustomField(productAsMap);
        Object[] objectArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Object component = objectArray[n2];
            Map compo = (Map)component;
            Component newComponent = new Component();
            newComponent.setId((Integer)compo.get(ID));
            newComponent.setName((String)compo.get(NAME));
            newComponent.setNonCustomField(nonCustomFields);
            newComponent.setCustomFields(this.filterCustomField(customFields, product, newComponent));
            listeComponent.add(newComponent);
            ++n2;
        }
        return listeComponent;
    }

    private List<BugzillaField> filterCustomField(List<BugzillaField> customFields, Product product, Component component) {
        return customFields.stream().filter(field -> this.visibilityIsNotComponentOrProduct((BugzillaField)field) || this.customFieldIsVisibleForComponent((BugzillaField)field, component) || this.customFieldIsVisibleForProduct((BugzillaField)field, product)).collect(Collectors.toList());
    }

    private boolean visibilityIsNotComponentOrProduct(BugzillaField custom) {
        return !"component".equals(custom.getVisibilityField()) && !"product".equals(custom.getVisibilityField());
    }

    private boolean customFieldIsVisibleForComponent(BugzillaField custom, Component component) {
        return "component".equals(custom.getVisibilityField()) && custom.getVisibilityValues().contains(component.getName());
    }

    private boolean customFieldIsVisibleForProduct(BugzillaField custom, Product product) {
        return "product".equals(custom.getVisibilityField()) && custom.getVisibilityValues().contains(product.getName());
    }

    public void addCustomFieldForBugCreation(Map<String, Object> executionData, Bug bug) {
        if (bug.getCustomFields() != null) {
            for (BugzillaField custom : bug.getCustomFields()) {
                executionData.put(custom.getName(), custom.getValues());
            }
        }
    }
}

