/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Layout;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItemType;

public abstract class FieldVisibilityStrategy {
    public abstract boolean isFieldVisible(String var1, String var2, WorkItemType var3);

    public static class Patch
    extends FieldVisibilityStrategy {
        private static Logger LOGGER = LoggerFactory.getLogger(Patch.class);
        private static String JSON_DATA_PATH = "./default-fields-visibility.json";
        private Map<String, Map<String, List<String>>> configuration;

        public Patch() {
            try {
                Resource resource = new PathMatchingResourcePatternResolver().getResource(JSON_DATA_PATH);
                this.configuration = (Map)new ObjectMapper().readValue(resource.getInputStream(), Map.class);
            }
            catch (IOException e) {
                LOGGER.error("Error while trying to read fields visibility configuration file. All fields are considered visible.");
                LOGGER.error(e.getMessage());
            }
        }

        @Override
        public boolean isFieldVisible(String rootProcessName, String fieldReferenceName, WorkItemType workItemType) {
            Map<String, List<String>> processConfiguration;
            if (this.configuration == null) {
                return true;
            }
            if (this.configuration.containsKey(rootProcessName) && (processConfiguration = this.configuration.get(rootProcessName)).containsKey(workItemType.getReferenceName())) {
                List<String> visibleFields = processConfiguration.get(workItemType.getReferenceName());
                return visibleFields.contains(fieldReferenceName);
            }
            return false;
        }
    }

    public static class LayoutBased
    extends FieldVisibilityStrategy {
        public final Layout layout;
        private static Logger LOGGER = LoggerFactory.getLogger(Patch.class);
        private static String JSON_DATA_PATH = "./hidden-fields.json";
        private Map<String, Map<String, List<String>>> hiddenFieldsConf;

        public LayoutBased(Layout layout) {
            this.layout = layout;
            try {
                Resource resource = new PathMatchingResourcePatternResolver().getResource(JSON_DATA_PATH);
                this.hiddenFieldsConf = (Map)new ObjectMapper().readValue(resource.getInputStream(), Map.class);
            }
            catch (IOException e) {
                LOGGER.error("Error while trying to read fields visibility configuration file. All fields are considered visible.");
                LOGGER.error(e.getMessage());
            }
        }

        @Override
        public boolean isFieldVisible(String rootProcessName, String fieldReferenceName, WorkItemType workItemType) {
            for (Layout.Page page : this.layout.getPages()) {
                for (Layout.Section section : page.getSections()) {
                    for (Layout.Group group : section.getGroups()) {
                        for (Layout.Control control : group.getControls()) {
                            if (!fieldReferenceName.equals(control.getId()) || !this.hiddenFieldsConf.containsKey(rootProcessName)) continue;
                            Map<String, List<String>> hiddenFields = this.hiddenFieldsConf.get(rootProcessName);
                            List<String> hiddenFieldsForThisType = hiddenFields.get(workItemType.getInherits());
                            boolean isCustomWorkItemType = hiddenFieldsForThisType == null;
                            boolean isVisibleInGroup = isCustomWorkItemType || !hiddenFieldsForThisType.contains(fieldReferenceName);
                            return control.isVisible() && page.isVisible() && group.isVisible() && isVisibleInGroup;
                        }
                    }
                }
            }
            return false;
        }
    }
}

