/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class PathBuilder {
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private final String uri;
    public static final String ROOT_API = "_apis";

    private PathBuilder(String uri) {
        this.uri = uri;
    }

    public static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not encode this value : " + value);
        }
    }

    public static PathBuilder buildProjectsPath(String organizationName) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "projects")));
    }

    public static PathBuilder buildProjectPath(String organizationName, String projectName) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "projects", PathBuilder.encodeValue(projectName))));
    }

    public static PathBuilder buildProcessWorkItemTypesPath(String organizationName, String processTemplateTypeId) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "work", "processes", PathBuilder.encodeValue(processTemplateTypeId), "workitemtypes")));
    }

    public static PathBuilder buildExpandedWorkItemFieldPath(String organizationName, String processTemplateTypeId, String workItemType, String fieldRefName) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "work", "processes", PathBuilder.encodeValue(processTemplateTypeId), "workitemtypes", PathBuilder.encodeValue(workItemType), "fields", PathBuilder.encodeValue(fieldRefName))));
    }

    public static PathBuilder buildProcessPath(String organizationName, String processTemplateTypeId) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "work", "processes", PathBuilder.encodeValue(processTemplateTypeId))));
    }

    public static PathBuilder buildAllFieldsPath(String organizationName, String projectName) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), PathBuilder.encodeValue(projectName), ROOT_API, "wit", "fields")));
    }

    public static PathBuilder buildProjectPropertiesPath(String organizationName, String projectId) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "projects", PathBuilder.encodeValue(projectId), "properties")));
    }

    public static PathBuilder buildTeamsPath(String organizationName, String projectName) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "projects", PathBuilder.encodeValue(projectName), "teams")));
    }

    public static PathBuilder buildTeamMembersPath(String organizationName, String projectName, String teamId) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "projects", PathBuilder.encodeValue(projectName), "teams", PathBuilder.encodeValue(teamId), "members")));
    }

    public static PathBuilder buildWorkItemTypesBasePath(String organizationName, String projectName, String ... fragments) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList("", PathBuilder.encodeValue(organizationName), PathBuilder.encodeValue(projectName), ROOT_API, "wit"));
        parts.addAll(Arrays.asList(fragments));
        return new PathBuilder(String.join((CharSequence)"/", parts));
    }

    public static PathBuilder buildWorkItemTypesFields(String organizationName, String projectName, String wit) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), PathBuilder.encodeValue(projectName), ROOT_API, "wit", "workitemtypes", PathBuilder.encodeValue(wit))));
    }

    public static PathBuilder buildLayoutPath(String organizationName, String processTemplateTypeId, String workItemType) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), ROOT_API, "work", "processes", PathBuilder.encodeValue(processTemplateTypeId), "workitemtypes", PathBuilder.encodeValue(workItemType), "layout")));
    }

    public static PathBuilder buildTemplatesPath(String organizationName, String projectIdOrName, String teamIdOrName) {
        return new PathBuilder(String.join((CharSequence)"/", Arrays.asList("", PathBuilder.encodeValue(organizationName), PathBuilder.encodeValue(projectIdOrName), PathBuilder.encodeValue(teamIdOrName), ROOT_API, "wit", "templates")));
    }

    public PathBuilder withQueryParam(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    public String build() {
        if (this.queryParams.isEmpty()) {
            return this.uri;
        }
        String params = this.queryParams.entrySet().stream().map(entry -> "%s=%s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        return "%s?%s".formatted(this.uri, params);
    }
}

