/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.ActivationStatus;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.HardwareID;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.LicenseKey;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.LicenseText;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.LicenseValidator;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.ModificationStatus;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.ValidationStatus;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.exceptions.LicenseSecurityException;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.util.Crypto;

public class License {
    private LicenseText a = null;
    private LicenseKey b = null;
    private ValidationStatus c = null;
    private ActivationStatus d = null;
    private ModificationStatus e = null;
    private String f;
    private ScheduledExecutorService g = null;
    private ScheduledExecutorService h = null;
    private Thread i = null;
    private int j = 0;
    private static String k = "License4J HTTPClient";
    private long l;

    /*
     * WARNING - void declaration
     */
    protected License(LicenseText licenseText, String publicKey, ValidationStatus validationStatus) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.a = var1_1;
        this.c = var3_3;
        this.f = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected License(LicenseKey licenseKey, String publicKey, ValidationStatus validationStatus) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.b = var1_1;
        this.c = var3_3;
        this.f = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected License(ValidationStatus validationStatus) {
        void var1_1;
        this.c = var1_1;
    }

    public ValidationStatus getValidationStatus() {
        return this.c;
    }

    public ModificationStatus getModificationStatus() {
        if (this.getValidationStatus() != ValidationStatus.LICENSE_VALID && this.getValidationStatus() == ValidationStatus.LICENSE_EXPIRED && this.getValidationStatus() == ValidationStatus.LICENSE_MAINTENANCE_EXPIRED) {
            Logger.getLogger(LicenseValidator.class.getName()).log(Level.SEVERE, "Given License Validation Status is INVALID.");
        } else if (this.getActivationStatus() != ActivationStatus.ACTIVATION_COMPLETED) {
            Logger.getLogger(LicenseValidator.class.getName()).log(Level.SEVERE, "Given License Activation Status is NOT ACTIVATION COMPLETED.");
        } else if (this.getLicenseText() == null) {
            Logger.getLogger(LicenseValidator.class.getName()).log(Level.SEVERE, "Modification is only supported for activated license text, activation code cannot be modified.");
        }
        return this.e;
    }

    public ActivationStatus getActivationStatus() {
        if (this.d == null) {
            if (this.a != null) {
                this.d = this.a.isActivationRequired() ? ActivationStatus.ACTIVATION_REQUIRED : (this.a.isActivationCompleted() ? ActivationStatus.ACTIVATION_COMPLETED : ActivationStatus.ACTIVATION_NOT_REQUIRED);
            } else if (this.b != null) {
                this.d = this.b.isActivationRequired() ? ActivationStatus.ACTIVATION_REQUIRED : (this.b.isActivationCompleted() ? ActivationStatus.ACTIVATION_COMPLETED : ActivationStatus.ACTIVATION_NOT_REQUIRED);
            }
        }
        return this.d;
    }

    protected final void a(ValidationStatus validationStatus) {
        this.c = validationStatus;
    }

    protected final void a(ActivationStatus activationStatus) {
        this.d = activationStatus;
    }

    protected final void a(ModificationStatus modificationStatus) {
        this.e = modificationStatus;
    }

    public String getLicenseString() {
        if (this.a != null) {
            try {
                return this.a.getContent(this.f);
            }
            catch (LicenseSecurityException licenseSecurityException) {
                Logger.getLogger(License.class.getName()).log(Level.SEVERE, null, licenseSecurityException);
            }
        } else if (this.b != null) {
            if (this.getActivationStatus() == ActivationStatus.ACTIVATION_COMPLETED) {
                return this.b.getTheKey() + "-" + this.b.getHardwareIDValidationMethod();
            }
            return this.b.getTheKey();
        }
        return null;
    }

    public String getManualActivationRequestString() {
        if (this.getActivationStatus() == ActivationStatus.ACTIVATION_NOT_REQUIRED) {
            return null;
        }
        String string = "";
        String string2 = HardwareID.getHardwareIDFromHostName();
        String string3 = HardwareID.getHardwareIDFromEthernetAddress();
        String string4 = HardwareID.getHardwareIDFromVolumeSerialNumber();
        String string5 = HardwareID.getHardwareIDFromHDDSerial();
        if (string2 != null) {
            string = string2;
        }
        if (string3 != null) {
            string = string + "!" + string3;
        }
        if (string4 != null) {
            string = string + "!" + string4;
        }
        if (string5 != null) {
            string = string + "!" + string5;
        }
        string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (string2.length() == 0) {
            string2 = "unknown";
        }
        string3 = this.getLicenseString();
        string4 = System.getProperty("os.name");
        if (string4 == null || string4.length() == 0) {
            string4 = "unknown";
        }
        string = string2 + "@" + string4 + "@" + string + "@" + this.f.hashCode() + "@" + string3 + "@";
        string2 = "";
        try {
            string2 = Crypto.encrypt(string, "rManuelActivate");
        }
        catch (Exception exception) {}
        return string2;
    }

    public String getManualActivationRequestStringWithCustomHardwareID(String customHardwareID) {
        String string;
        if (this.getActivationStatus() == ActivationStatus.ACTIVATION_NOT_REQUIRED) {
            return null;
        }
        if (customHardwareID == null || customHardwareID.length() == 0) {
            return null;
        }
        String string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (string2.length() == 0) {
            string2 = "unknown";
        }
        String string3 = this.getLicenseString();
        String string4 = System.getProperty("os.name");
        if (string4 == null || string4.length() == 0) {
            string4 = "unknown";
        }
        string = string2 + "@" + string4 + "@cid-" + string + "@" + this.f.hashCode() + "@" + string3 + "@";
        string2 = "";
        try {
            string2 = Crypto.encrypt(string, "rManuelActivate");
        }
        catch (Exception exception) {}
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public String getManualActivationRequestStringWithUserInformation(boolean modifyOnlyOnFirstActivation, String fullname, String registeredto, String email, String company, String street, String telnumber, String faxnumber, String city, String zip, String country) {
        void var3_4;
        String string;
        void var1_1;
        if (this.getActivationStatus() == ActivationStatus.ACTIVATION_NOT_REQUIRED) {
            return null;
        }
        String string2 = "";
        String string3 = HardwareID.getHardwareIDFromHostName();
        String string4 = HardwareID.getHardwareIDFromEthernetAddress();
        String string5 = HardwareID.getHardwareIDFromVolumeSerialNumber();
        String string6 = HardwareID.getHardwareIDFromHDDSerial();
        if (string3 != null) {
            string2 = string3;
        }
        if (string4 != null) {
            string2 = string2 + "!" + string4;
        }
        if (string5 != null) {
            string2 = string2 + "!" + string5;
        }
        if (string6 != null) {
            string2 = string2 + "!" + string6;
        }
        string3 = "";
        try {
            string3 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (string3.length() == 0) {
            string3 = "unknown";
        }
        string4 = this.getLicenseString();
        string5 = System.getProperty("os.name");
        if (string5 == null || string5.length() == 0) {
            string5 = "unknown";
        }
        String string7 = string3 + "@" + string5 + "@" + string2 + "@" + this.f.hashCode() + "@" + string4 + "@" + (var1_1 == true ? "true" : "false") + "@" + (fullname != null && fullname.length() > 0 ? string : "~") + "@" + (String)(registeredto != null && registeredto.length() > 0 ? var3_4 : "~") + "@" + (email != null && email.length() > 0 ? email : "~") + "@" + (company != null && company.length() > 0 ? company : "~") + "@" + (street != null && street.length() > 0 ? street : "~") + "@" + (telnumber != null && telnumber.length() > 0 ? telnumber : "~") + "@" + (faxnumber != null && faxnumber.length() > 0 ? faxnumber : "~") + "@" + (city != null && city.length() > 0 ? city : "~") + "@" + (zip != null && zip.length() > 0 ? zip : "~") + "@" + (country != null && country.length() > 0 ? country : "~");
        string = "";
        try {
            string = Crypto.encrypt(string7, "rManuelActivate");
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String getManualActivationRequestStringWithCustomHardwareIDWithUserInformation(String customHardwareID, boolean modifyOnlyOnFirstActivation, String fullname, String registeredto, String email, String company, String street, String telnumber, String faxnumber, String city, String zip, String country) {
        void var3_4;
        void var2_2;
        String string;
        if (this.getActivationStatus() == ActivationStatus.ACTIVATION_NOT_REQUIRED) {
            return null;
        }
        if (customHardwareID == null || customHardwareID.length() == 0) {
            return null;
        }
        String string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (string2.length() == 0) {
            string2 = "unknown";
        }
        String string3 = this.getLicenseString();
        String string4 = System.getProperty("os.name");
        if (string4 == null || string4.length() == 0) {
            string4 = "unknown";
        }
        string = string2 + "@" + string4 + "@cid-" + string + "@" + this.f.hashCode() + "@" + string3 + "@" + (var2_2 == true ? "true" : "false") + "@" + (String)(fullname != null && fullname.length() > 0 ? var3_4 : "~") + "@" + (registeredto != null && registeredto.length() > 0 ? registeredto : "~") + "@" + (email != null && email.length() > 0 ? email : "~") + "@" + (company != null && company.length() > 0 ? company : "~") + "@" + (street != null && street.length() > 0 ? street : "~") + "@" + (telnumber != null && telnumber.length() > 0 ? telnumber : "~") + "@" + (faxnumber != null && faxnumber.length() > 0 ? faxnumber : "~") + "@" + (city != null && city.length() > 0 ? city : "~") + "@" + (zip != null && zip.length() > 0 ? zip : "~") + "@" + (country != null && country.length() > 0 ? country : "~");
        String string5 = "";
        try {
            string5 = Crypto.encrypt(string, "rManuelActivate");
        }
        catch (Exception exception) {}
        return string5;
    }

    public String getManualModificationRequestString(String modificationKey) {
        String string;
        String string2;
        if (this.getActivationStatus() != ActivationStatus.ACTIVATION_COMPLETED) {
            return null;
        }
        if (this.getLicenseString().length() < 70) {
            return null;
        }
        String string3 = "";
        try {
            string3 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (string3.length() == 0) {
            string3 = "unknown";
        }
        if ((string2 = System.getProperty("os.name")) == null || string2.length() == 0) {
            string2 = "unknown";
        }
        String string4 = null;
        if (this.getLicenseText() != null) {
            string4 = String.valueOf(this.getLicenseText().getActivationID());
        }
        string = string3 + "@" + string2 + "@" + this.f.hashCode() + "@" + string4 + "@" + string;
        string3 = "";
        try {
            string3 = Crypto.encrypt(string, "rManuelModify");
        }
        catch (Exception exception) {}
        return string3;
    }

    public String getManualDeactivationRequestString() {
        if (this.getActivationStatus() != ActivationStatus.ACTIVATION_COMPLETED) {
            return null;
        }
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (string.length() == 0) {
            string = "unknown";
        }
        String string2 = this.getLicenseString();
        String string3 = System.getProperty("os.name");
        if (string3 == null || string3.length() == 0) {
            string3 = "unknown";
        }
        String string4 = null;
        if (this.getLicenseText() != null) {
            string4 = String.valueOf(this.getLicenseText().getActivationID());
        }
        string = string4 == null ? string + "@" + string3 + "@" + this.f.hashCode() + "@" + string2 + "@" : string + "@" + string3 + "@" + this.f.hashCode() + "@" + string2 + "@" + string4 + "@";
        string2 = "";
        try {
            string2 = Crypto.encrypt(string, "rManuelDeActivate");
        }
        catch (Exception exception) {}
        return string2;
    }

    public String getPublicKey() {
        return this.f;
    }

    public boolean isActivationRequired() {
        if (this.a != null) {
            return this.a.isActivationRequired();
        }
        if (this.b != null) {
            return this.b.isActivationRequired();
        }
        return false;
    }

    public boolean isActivationCompleted() {
        if (this.a != null) {
            return this.a.isActivationCompleted();
        }
        if (this.b != null) {
            return this.b.isActivationCompleted();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int getLicenseActivationDaysRemaining(Date currentDate) {
        if (this.a != null) {
            return this.a.getLicenseActivationDaysRemaining(currentDate);
        }
        if (this.b != null) {
            void var1_1;
            return this.b.getLicenseActivationDaysRemaining((Date)var1_1);
        }
        return -1;
    }

    public int getLicenseActivationPeriod(Date currentDate) {
        if (this.a != null) {
            return this.a.getActivationPeriod();
        }
        if (this.b != null) {
            return this.b.getActivationPeriod();
        }
        return -1;
    }

    public LicenseText getLicenseText() {
        return this.a;
    }

    public LicenseKey getLicenseKey() {
        return this.b;
    }

    public int getUseCountCurrent() {
        String string;
        int n = 0;
        if (this.getLicenseText() != null && (string = this.getLicenseText().getCustomSignedFeature("use-count")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public int getUseCountAllowed() {
        String string;
        int n = 0;
        if (this.getLicenseText() != null && (string = this.getLicenseText().getCustomSignedFeature("allowed-use-count")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public long getUseTimeCurrent() {
        String string;
        long l = 0L;
        if (this.getLicenseText() != null && (string = this.getLicenseText().getCustomSignedFeature("use-time")) != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {}
        }
        return l / 1000L;
    }

    public long getUseTimeLimitAllowed() {
        String string;
        long l = 0L;
        if (this.getLicenseText() != null && (string = this.getLicenseText().getCustomSignedFeature("allowed-use-time")) != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {}
        }
        return l * 60L;
    }

    public String getUsedModificationKeys() {
        String string = null;
        if (this.getLicenseText() != null) {
            string = this.getLicenseText().getCustomSignedFeature("license-modified-by");
        }
        return string;
    }

    protected final ScheduledExecutorService a() {
        return this.g;
    }

    protected final void a(ScheduledExecutorService scheduledExecutorService) {
        this.g = scheduledExecutorService;
    }

    protected final ScheduledExecutorService b() {
        return this.h;
    }

    protected final void b(ScheduledExecutorService scheduledExecutorService) {
        this.h = scheduledExecutorService;
    }

    protected final Thread c() {
        return this.i;
    }

    protected final void a(Thread thread) {
        this.i = thread;
    }

    public synchronized void stopFloatingLicenseCheckTimers() {
        if (this.g != null) {
            this.g.shutdownNow();
        }
        if (this.h != null) {
            this.h.shutdownNow();
        }
        if (this.i != null) {
            Runtime.getRuntime().removeShutdownHook(this.i);
        }
    }

    public synchronized void releaseFloatingLicense() {
        this.stopFloatingLicenseCheckTimers();
        if (this.i != null && this.i.getState() == Thread.State.NEW) {
            this.i.start();
            this.c = ValidationStatus.LICENSE_INVALID;
            this.a = null;
        }
    }

    public int getFloatingLicenseServerVersion() {
        return this.j;
    }

    protected final void a(int n) {
        this.j = n;
    }

    public String[] checkForNewMessage() {
        return this.checkForNewMessage(null);
    }

    /*
     * Loose catch block
     */
    public String[] checkForNewMessage(String licenseServer) {
        String string;
        HttpURLConnection httpURLConnection;
        CharSequence charSequence;
        boolean bl;
        String[] stringArray;
        block52: {
            InputStreamReader inputStreamReader;
            Closeable closeable;
            block50: {
                block51: {
                    stringArray = "~@~".split("~@~");
                    bl = true;
                    if (licenseServer == null || licenseServer.startsWith("http://")) {
                        bl = false;
                    }
                    if ((charSequence = HardwareID.getHardwareIDFromEthernetAddress()) == null) {
                        charSequence = "unknown";
                        try {
                            charSequence = InetAddress.getLocalHost().getHostName();
                        }
                        catch (UnknownHostException unknownHostException) {}
                    }
                    try {
                        httpURLConnection = licenseServer == null ? (HttpsURLConnection)new URL("https://online.license4j.com/e/checkmessageupdate").openConnection() : (bl ? (HttpsURLConnection)new URL((String)((Object)httpURLConnection)).openConnection() : (HttpURLConnection)new URL((String)((Object)httpURLConnection)).openConnection());
                        httpURLConnection.setConnectTimeout(10000);
                        httpURLConnection.setReadTimeout(10000);
                        if (System.getProperty("license4j-user-agent") != null) {
                            k = System.getProperty("license4j-user-agent");
                        }
                        httpURLConnection.setRequestProperty("User-Agent", k);
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
                        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                    }
                    catch (Exception exception) {
                        return stringArray;
                    }
                    string = String.valueOf(this.getPublicKey().hashCode());
                    closeable = null;
                    closeable = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
                    ((Writer)closeable).write("action=cfnm&");
                    if (this.getActivationStatus() == ActivationStatus.ACTIVATION_COMPLETED) {
                        ((Writer)closeable).write("lsa=" + this.getLicenseString() + "&");
                    } else if (this.getLicenseText() != null && this.getLicenseText().getCustomSignedFeature("use-count") != null) {
                        ((Writer)closeable).write("lso=" + this.getLicenseString() + "&");
                    } else {
                        ((Writer)closeable).write("ls=" + this.getLicenseString() + "&");
                    }
                    ((Writer)closeable).write("chon=" + (String)charSequence + "&");
                    ((Writer)closeable).write("pa=" + string + "&");
                    try {
                        ((OutputStreamWriter)closeable).close();
                    }
                    catch (Exception exception) {}
                    break block51;
                    catch (Exception exception) {
                        String[] stringArray2 = stringArray;
                        if (closeable != null) {
                            try {
                                ((OutputStreamWriter)closeable).close();
                            }
                            catch (Exception exception2) {}
                        }
                        return stringArray2;
                    }
                    catch (Throwable throwable) {
                        if (closeable != null) {
                            try {
                                ((OutputStreamWriter)closeable).close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                }
                charSequence = new StringBuilder();
                inputStreamReader = null;
                closeable = null;
                int n = bl ? ((HttpsURLConnection)httpURLConnection).getResponseCode() : httpURLConnection.getResponseCode();
                if (n == 200 || n == 200) {
                    String string2;
                    inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
                    closeable = new BufferedReader(inputStreamReader);
                    while ((string2 = ((BufferedReader)closeable).readLine()) != null) {
                        ((StringBuilder)charSequence).append(string2);
                    }
                }
                if (inputStreamReader == null) break block50;
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (closeable != null) {
                try {
                    ((BufferedReader)closeable).close();
                }
                catch (Exception exception) {}
            }
            break block52;
            catch (Exception exception) {
                String[] stringArray3 = stringArray;
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception3) {}
                }
                if (closeable != null) {
                    try {
                        ((BufferedReader)closeable).close();
                    }
                    catch (Exception exception4) {}
                }
                return stringArray3;
            }
            catch (Throwable throwable) {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (closeable != null) {
                    try {
                        ((BufferedReader)closeable).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
        }
        if (bl) {
            ((HttpsURLConnection)httpURLConnection).disconnect();
        } else {
            httpURLConnection.disconnect();
        }
        String string3 = ((StringBuilder)charSequence).toString().trim();
        if (string3.length() >= string.length() && string.compareToIgnoreCase(string3.substring(0, string.length())) == 0) {
            string3 = ((StringBuilder)charSequence).toString().substring(string.length());
            if (string3.length() > 3 && string3.startsWith("~@~")) {
                string3 = string3.substring(3);
            } else if (string3.length() <= 3) {
                string3 = "~@~";
            }
            stringArray = string3.split("~@~");
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public String checkForUpdate(String productEdition, String productVersion) {
        void var2_2;
        void var1_1;
        return this.checkForUpdate((String)var1_1, (String)var2_2, null);
    }

    /*
     * Loose catch block
     */
    public String checkForUpdate(String productEdition, String productVersion, String licenseServer) {
        StringBuilder stringBuilder;
        String string;
        HttpURLConnection httpURLConnection;
        boolean bl;
        String string2;
        block53: {
            InputStreamReader inputStreamReader;
            Object object;
            block51: {
                Object object2;
                block52: {
                    string2 = null;
                    bl = true;
                    if (licenseServer == null || licenseServer.startsWith("http://")) {
                        bl = false;
                    }
                    if ((object = HardwareID.getHardwareIDFromEthernetAddress()) == null) {
                        object = "unknown";
                        try {
                            object = InetAddress.getLocalHost().getHostName();
                        }
                        catch (UnknownHostException unknownHostException) {}
                    }
                    try {
                        httpURLConnection = licenseServer == null ? (HttpsURLConnection)new URL("https://online.license4j.com/e/checkmessageupdate").openConnection() : (bl ? (HttpsURLConnection)new URL((String)((Object)httpURLConnection)).openConnection() : (HttpURLConnection)new URL((String)((Object)httpURLConnection)).openConnection());
                        httpURLConnection.setConnectTimeout(10000);
                        httpURLConnection.setReadTimeout(10000);
                        if (System.getProperty("license4j-user-agent") != null) {
                            k = System.getProperty("license4j-user-agent");
                        }
                        httpURLConnection.setRequestProperty("User-Agent", k);
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
                        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    string = String.valueOf(this.getPublicKey().hashCode());
                    object2 = null;
                    object2 = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
                    ((Writer)object2).write("action=cfu&");
                    if (this.getActivationStatus() == ActivationStatus.ACTIVATION_COMPLETED) {
                        ((Writer)object2).write("lsa=" + this.getLicenseString() + "&");
                    } else if (this.getLicenseText() != null && this.getLicenseText().getCustomSignedFeature("use-count") != null) {
                        ((Writer)object2).write("lso=" + this.getLicenseString() + "&");
                    } else {
                        ((Writer)object2).write("ls=" + this.getLicenseString() + "&");
                    }
                    if (productVersion == null || productVersion.trim().length() == 0) {
                        productVersion = "~";
                    }
                    if (productEdition == null || productEdition.trim().length() == 0) {
                        productEdition = "~";
                    }
                    if (productEdition.length() > 64) {
                        productEdition = productEdition.substring(0, 64);
                    }
                    if (productVersion.length() > 64) {
                        productVersion = productVersion.substring(0, 64);
                    }
                    ((Writer)object2).write("e=" + (String)((Object)stringBuilder) + "&");
                    ((Writer)object2).write("v=" + (String)((Object)inputStreamReader) + "&");
                    ((Writer)object2).write("chon=" + (String)object + "&");
                    ((Writer)object2).write("pa=" + string + "&");
                    try {
                        ((OutputStreamWriter)object2).close();
                    }
                    catch (Exception exception) {}
                    break block52;
                    catch (Exception exception) {
                        if (object2 != null) {
                            try {
                                ((OutputStreamWriter)object2).close();
                            }
                            catch (Exception exception2) {}
                        }
                        return null;
                    }
                    catch (Throwable throwable) {
                        if (object2 != null) {
                            try {
                                ((OutputStreamWriter)object2).close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                }
                stringBuilder = new StringBuilder();
                inputStreamReader = null;
                object = null;
                int n = bl ? ((HttpsURLConnection)httpURLConnection).getResponseCode() : httpURLConnection.getResponseCode();
                if (n == 200 || n == 200) {
                    inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
                    object = new BufferedReader(inputStreamReader);
                    while ((object2 = ((BufferedReader)object).readLine()) != null) {
                        stringBuilder.append((String)object2);
                    }
                }
                if (inputStreamReader == null) break block51;
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {}
            }
            break block53;
            catch (Exception exception) {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception3) {}
                }
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Exception exception4) {}
                }
                return null;
            }
            catch (Throwable throwable) {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
        }
        if (bl) {
            ((HttpsURLConnection)httpURLConnection).disconnect();
        } else {
            httpURLConnection.disconnect();
        }
        String string3 = stringBuilder.toString().trim();
        if (string3.length() >= string.length() && string.compareToIgnoreCase(string3.substring(0, string.length())) == 0 && (string2 = string3.substring(string.length() + 3)).trim().length() < 3) {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public String checkForUpdateMessage(String productEdition, String newVersion) {
        void var2_2;
        void var1_1;
        return this.checkForUpdateMessage((String)var1_1, (String)var2_2, null);
    }

    /*
     * Loose catch block
     */
    public String checkForUpdateMessage(String productEdition, String newVersion, String licenseServer) {
        StringBuilder stringBuilder;
        String string;
        HttpURLConnection httpURLConnection;
        boolean bl;
        String string2;
        block50: {
            InputStreamReader inputStreamReader;
            Closeable closeable;
            block48: {
                block49: {
                    string2 = null;
                    bl = true;
                    if (licenseServer == null || licenseServer.startsWith("http://")) {
                        bl = false;
                    }
                    try {
                        httpURLConnection = licenseServer == null ? (HttpsURLConnection)new URL("https://online.license4j.com/e/checkmessageupdate").openConnection() : (bl ? (HttpsURLConnection)new URL((String)((Object)httpURLConnection)).openConnection() : (HttpURLConnection)new URL((String)((Object)httpURLConnection)).openConnection());
                        httpURLConnection.setConnectTimeout(10000);
                        httpURLConnection.setReadTimeout(10000);
                        if (System.getProperty("license4j-user-agent") != null) {
                            k = System.getProperty("license4j-user-agent");
                        }
                        httpURLConnection.setRequestProperty("User-Agent", k);
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
                        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    string = String.valueOf(this.getPublicKey().hashCode());
                    closeable = null;
                    closeable = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
                    ((Writer)closeable).write("action=cfum&");
                    if (this.getActivationStatus() == ActivationStatus.ACTIVATION_COMPLETED) {
                        ((Writer)closeable).write("lsa=" + this.getLicenseString() + "&");
                    } else if (this.getLicenseText() != null && this.getLicenseText().getCustomSignedFeature("use-count") != null) {
                        ((Writer)closeable).write("lso=" + this.getLicenseString() + "&");
                    } else {
                        ((Writer)closeable).write("ls=" + this.getLicenseString() + "&");
                    }
                    if (newVersion == null || newVersion.trim().length() == 0) {
                        newVersion = "~";
                    }
                    if (productEdition == null || productEdition.trim().length() == 0) {
                        productEdition = "~";
                    }
                    if (productEdition.length() > 64) {
                        productEdition = productEdition.substring(0, 64);
                    }
                    if (newVersion.length() > 64) {
                        newVersion = newVersion.substring(0, 64);
                    }
                    ((Writer)closeable).write("e=" + (String)((Object)stringBuilder) + "&");
                    ((Writer)closeable).write("v=" + (String)((Object)inputStreamReader) + "&");
                    ((Writer)closeable).write("pa=" + string + "&");
                    try {
                        ((OutputStreamWriter)closeable).close();
                    }
                    catch (Exception exception) {}
                    break block49;
                    catch (Exception exception) {
                        if (closeable != null) {
                            try {
                                ((OutputStreamWriter)closeable).close();
                            }
                            catch (Exception exception2) {}
                        }
                        return null;
                    }
                    catch (Throwable throwable) {
                        if (closeable != null) {
                            try {
                                ((OutputStreamWriter)closeable).close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                }
                stringBuilder = new StringBuilder();
                inputStreamReader = null;
                closeable = null;
                int n = bl ? ((HttpsURLConnection)httpURLConnection).getResponseCode() : httpURLConnection.getResponseCode();
                if (n == 200 || n == 200) {
                    String string3;
                    inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
                    closeable = new BufferedReader(inputStreamReader);
                    while ((string3 = ((BufferedReader)closeable).readLine()) != null) {
                        stringBuilder.append(string3);
                    }
                }
                if (inputStreamReader == null) break block48;
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (closeable != null) {
                try {
                    ((BufferedReader)closeable).close();
                }
                catch (Exception exception) {}
            }
            break block50;
            catch (Exception exception) {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception3) {}
                }
                if (closeable != null) {
                    try {
                        ((BufferedReader)closeable).close();
                    }
                    catch (Exception exception4) {}
                }
                return null;
            }
            catch (Throwable throwable) {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (closeable != null) {
                    try {
                        ((BufferedReader)closeable).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
        }
        if (bl) {
            ((HttpsURLConnection)httpURLConnection).disconnect();
        } else {
            httpURLConnection.disconnect();
        }
        String string4 = stringBuilder.toString().trim();
        if (string4.length() >= string.length() && string.compareToIgnoreCase(string4.substring(0, string.length())) == 0 && (string4 = stringBuilder.toString().substring(string.length())).length() > 3 && string4.startsWith("~@~")) {
            string2 = string4.substring(3);
        }
        return string2;
    }

    protected final long d() {
        return this.l;
    }

    protected final void a(long l) {
        this.l = l;
    }
}

