/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.utils;

import jakarta.inject.Inject;
import java.util.function.Supplier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.utils.RestTemplateFactory;

public abstract class RestTemplateAbstractFactory
implements RestTemplateFactory,
InitializingBean {
    @Inject
    protected RestTemplateBuilder builder;
    protected Supplier<ClientHttpRequestFactory> springRequestFactory;

    @Override
    public RestTemplate restTemplate(BugTracker bugTracker) {
        String baseUrl = bugTracker.getUrl();
        DefaultUriBuilderFactory encodingBuilder = new DefaultUriBuilderFactory();
        encodingBuilder.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        return this.builder.rootUri(baseUrl).uriTemplateHandler((UriTemplateHandler)encodingBuilder).requestFactory(this.springRequestFactory).build();
    }

    protected abstract void initSpringRequestFactory();

    public void afterPropertiesSet() throws Exception {
        this.initSpringRequestFactory();
    }
}

