/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.internal.fetcher;

import java.util.concurrent.Executor;
import xsquash4gitlab.com.apollographql.apollo.api.internal.ApolloLogger;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Optional;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.com.apollographql.apollo.fetcher.ResponseFetcher;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptor;
import xsquash4gitlab.com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

public final class CacheAndNetworkFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheAndNetworkInterceptor();
    }

    private static final class CacheAndNetworkInterceptor
    implements ApolloInterceptor {
        private Optional<ApolloInterceptor.InterceptorResponse> cacheResponse = Optional.absent();
        private Optional<ApolloInterceptor.InterceptorResponse> networkResponse = Optional.absent();
        private Optional<ApolloException> cacheException = Optional.absent();
        private Optional<ApolloException> networkException = Optional.absent();
        private boolean dispatchedCacheResult;
        private ApolloInterceptor.CallBack originalCallback;
        private volatile boolean disposed;

        private CacheAndNetworkInterceptor() {
        }

        @Override
        public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
            if (this.disposed) {
                return;
            }
            this.originalCallback = callBack;
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    this.handleCacheResponse(response);
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    this.handleCacheError(e);
                }

                @Override
                public void onCompleted() {
                }

                @Override
                public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                    callBack.onFetch(sourceType);
                }
            });
            ApolloInterceptor.InterceptorRequest networkRequest = request.toBuilder().fetchFromCache(false).build();
            chain.proceedAsync(networkRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    this.handleNetworkResponse(response);
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    this.handleNetworkError(e);
                }

                @Override
                public void onCompleted() {
                }

                @Override
                public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                    callBack.onFetch(sourceType);
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        synchronized void handleNetworkResponse(ApolloInterceptor.InterceptorResponse response) {
            this.networkResponse = Optional.of(response);
            this.dispatch();
        }

        synchronized void handleNetworkError(ApolloException exception) {
            this.networkException = Optional.of(exception);
            this.dispatch();
        }

        synchronized void handleCacheResponse(ApolloInterceptor.InterceptorResponse response) {
            this.cacheResponse = Optional.of(response);
            this.dispatch();
        }

        synchronized void handleCacheError(ApolloException exception) {
            this.cacheException = Optional.of(exception);
            this.dispatch();
        }

        private synchronized void dispatch() {
            if (this.disposed) {
                return;
            }
            if (!this.dispatchedCacheResult) {
                if (this.cacheResponse.isPresent()) {
                    this.originalCallback.onResponse(this.cacheResponse.get());
                    this.dispatchedCacheResult = true;
                } else if (this.cacheException.isPresent()) {
                    this.dispatchedCacheResult = true;
                }
            }
            if (this.dispatchedCacheResult) {
                if (this.networkResponse.isPresent()) {
                    this.originalCallback.onResponse(this.networkResponse.get());
                    this.originalCallback.onCompleted();
                } else if (this.networkException.isPresent()) {
                    this.originalCallback.onFailure(this.networkException.get());
                }
            }
        }
    }
}

