/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.exception;

import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.okhttp3.Response;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

public final class ApolloHttpException
extends ApolloException {
    private final int code;
    private final String message;
    private final transient Response rawResponse;

    public ApolloHttpException(@Nullable Response rawResponse) {
        super(ApolloHttpException.formatMessage(rawResponse));
        this.code = rawResponse != null ? rawResponse.code() : 0;
        this.message = rawResponse != null ? rawResponse.message() : "";
        this.rawResponse = rawResponse;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    @Nullable
    public Response rawResponse() {
        return this.rawResponse;
    }

    private static String formatMessage(Response response) {
        if (response == null) {
            return "Empty HTTP response";
        }
        return "HTTP " + response.code() + " " + response.message();
    }
}

