/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo;

import xsquash4gitlab.com.apollographql.apollo.api.Operation;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloCanceledException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloHttpException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloNetworkException;
import xsquash4gitlab.com.apollographql.apollo.internal.util.Cancelable;
import xsquash4gitlab.okhttp3.Response;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

public interface ApolloPrefetch
extends Cancelable {
    public void enqueue(@Nullable Callback var1);

    public ApolloPrefetch clone();

    @NotNull
    public Operation operation();

    @Override
    public void cancel();

    public static interface Factory {
        public <D extends Operation.Data, T, V extends Operation.Variables> ApolloPrefetch prefetch(@NotNull Operation<D, T, V> var1);
    }

    public static abstract class Callback {
        public abstract void onSuccess();

        public abstract void onFailure(@NotNull ApolloException var1);

        public void onHttpError(@NotNull ApolloHttpException e) {
            this.onFailure(e);
            Response response = e.rawResponse();
            if (response != null) {
                response.close();
            }
        }

        public void onNetworkError(@NotNull ApolloNetworkException e) {
            this.onFailure(e);
        }

        public void onCanceledError(@NotNull ApolloCanceledException e) {
            this.onFailure(e);
        }
    }
}

