/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.Mappings;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabEntityHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabInstanceType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationReport;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientProvider;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.FieldMappingService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabIssueStatusPerimeterHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementImporter;
import org.squashtest.tm.plugin.xsquash4gitlab.service.finder.RemoteRequirementFinder;
import org.squashtest.tm.service.campaign.SprintReqVersionTestPlanManagerService;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.SprintRequirementSyncExtenderDao;

@Service(value="squash.tm.plugin.xsquash4gitlab.SynchronizedSprintRequirementVersionService")
@Transactional
public class SynchronizedSprintRequirementVersionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementImporter.class);
    private final ConfigurationService configurationService;
    private final SprintRequirementSyncExtenderDao sprintRequirementSyncExtenderDao;
    private final RequirementVersionDao requirementVersionDao;
    private final SprintReqVersionTestPlanManagerService sprintReqVersionTestPlanManagerService;
    private final GitLabClientProvider gitLabClientProvider;
    @PersistenceContext
    private EntityManager entityManager;

    public SynchronizedSprintRequirementVersionService(ConfigurationService configurationService, SprintRequirementSyncExtenderDao sprintRequirementSyncExtenderDao, RequirementVersionDao requirementVersionDao, SprintReqVersionTestPlanManagerService sprintReqVersionTestPlanManagerService, GitLabClientProvider gitLabClientProvider) {
        this.configurationService = configurationService;
        this.sprintRequirementSyncExtenderDao = sprintRequirementSyncExtenderDao;
        this.requirementVersionDao = requirementVersionDao;
        this.sprintReqVersionTestPlanManagerService = sprintReqVersionTestPlanManagerService;
        this.gitLabClientProvider = gitLabClientProvider;
    }

    public void createOrUpdateSprintReqVersions(Sprint squashSprint, List<GitLabIssue> issuesInSprint, RemoteRequirementFinder.Result finderResult, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        issuesInSprint.forEach(gitLabIssue -> {
            if (result.toCreate.contains(gitLabIssue)) {
                this.createSprintRequirementVersion(gitLabRemoteSynchronisation, (GitLabIssue)gitLabIssue, squashSprint);
            } else {
                this.handleSprintRequirementVersionUpdate(squashSprint, finderResult, gitLabRemoteSynchronisation, (GitLabIssue)gitLabIssue);
            }
        });
    }

    private void createSprintRequirementVersion(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, GitLabIssue gitLabIssue, Sprint squashSprint) {
        RequirementVersion reqVersion = this.requirementVersionDao.findByRemoteSyncIdAndIssueKey(Long.valueOf(squashSprint.getRemoteSynchronisation().getId()), gitLabIssue.getId());
        SprintReqVersion sprintReqVersion = new SprintReqVersion(squashSprint);
        sprintReqVersion.setReference(FieldMappingService.formatReference(gitLabIssue));
        sprintReqVersion.setName(gitLabIssue.getTitle());
        sprintReqVersion.setDescription(FieldMappingService.checkAndUpdateDescriptionForGitLabInternalLinksAndFiles(gitLabRemoteSynchronisation, gitLabIssue.getDescription()));
        sprintReqVersion.setMode(ManagementMode.SYNCHRONIZED);
        this.handleMappingsConfiguration(gitLabRemoteSynchronisation.getProject().getId(), gitLabRemoteSynchronisation.getId(), gitLabIssue.getLabels(), sprintReqVersion);
        if (Objects.nonNull(reqVersion)) {
            sprintReqVersion.setRequirementVersion(reqVersion);
        }
        this.entityManager.persist((Object)sprintReqVersion);
        this.sprintReqVersionTestPlanManagerService.addAllTestPlanItemsToSprintReqVersion(sprintReqVersion.getId());
        this.createSprintRequirementSyncExtender(sprintReqVersion, squashSprint, gitLabIssue, gitLabRemoteSynchronisation.getProject().getId(), gitLabRemoteSynchronisation.getId());
    }

    private void createSprintRequirementSyncExtender(SprintReqVersion sprintReqVersion, Sprint squashSprint, GitLabIssue gitLabIssue, long projectId, long syncId) {
        SprintRequirementSyncExtender sprintRequirementSyncExtender = new SprintRequirementSyncExtender();
        sprintRequirementSyncExtender.setSprintReqVersion(sprintReqVersion);
        sprintRequirementSyncExtender.setRemoteSynchronisation(squashSprint.getRemoteSynchronisation());
        sprintRequirementSyncExtender.setRemoteLastUpdated(gitLabIssue.getUpdatedAt());
        sprintRequirementSyncExtender.setRemoteProjectId(gitLabIssue.getProjectId().toString());
        sprintRequirementSyncExtender.setRemoteReqId(GitLabEntityHelper.getKey(gitLabIssue));
        boolean displayState = this.configurationService.getDisplayStateBySyncIdFromProject(projectId).getOrDefault(syncId, true);
        this.updateSyncExtenderRemoteReqState(gitLabIssue.getState().rawValue(), sprintRequirementSyncExtender, displayState);
        String url = gitLabIssue.getWebUrl();
        String issueKey = GitLabEntityHelper.getKey(gitLabIssue);
        try {
            sprintRequirementSyncExtender.setRemoteReqUrl(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Could not set URL correctly for issue {}.'", (Object)issueKey);
        }
        this.entityManager.persist((Object)sprintRequirementSyncExtender);
    }

    private void handleSprintRequirementVersionUpdate(Sprint squashSprint, RemoteRequirementFinder.Result finderResult, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, GitLabIssue gitLabIssue) {
        SprintRequirementSyncExtender sprintReqSyncExtender = this.sprintRequirementSyncExtenderDao.findBySprintIdRemoteSyncIdAndRemoteReqId(squashSprint.getId().longValue(), squashSprint.getRemoteSynchronisation().getId(), gitLabIssue.getId());
        if (Objects.isNull(sprintReqSyncExtender)) {
            return;
        }
        SprintReqVersion sprintReqVersion = sprintReqSyncExtender.getSprintReqVersion();
        boolean displayState = this.configurationService.getDisplayStateBySyncIdFromProject(gitLabRemoteSynchronisation.getProject().getId()).getOrDefault(gitLabRemoteSynchronisation.getRemoteSynchronisation().getId(), true);
        if (finderResult.toUpdate.contains(gitLabIssue)) {
            sprintReqSyncExtender.setRemoteLastUpdated(gitLabIssue.getUpdatedAt());
            this.updateSprintRequirementVersion(gitLabRemoteSynchronisation, sprintReqVersion, gitLabIssue);
        }
        sprintReqSyncExtender.setRemoteReqState(displayState ? gitLabIssue.getState().rawValue() : null);
        this.handleMappingsConfiguration(gitLabRemoteSynchronisation.getProject().getId(), gitLabRemoteSynchronisation.getId(), gitLabIssue.getLabels(), sprintReqVersion);
    }

    private void updateSyncExtenderRemoteReqState(String gitlabIssueState, SprintRequirementSyncExtender sprintReqSyncExtender, boolean displayState) {
        if (displayState) {
            sprintReqSyncExtender.setRemoteReqState(gitlabIssueState);
        } else {
            sprintReqSyncExtender.setRemoteReqState(null);
        }
    }

    private void updateSprintRequirementVersion(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, SprintReqVersion sprintReqVersion, GitLabIssue gitLabIssue) {
        if (Objects.nonNull(sprintReqVersion)) {
            this.checkAndUpdateNameAndReference(sprintReqVersion, gitLabIssue);
            this.checkAndUpdateDescription(gitLabRemoteSynchronisation, sprintReqVersion, gitLabIssue);
        }
    }

    private void handleMappingsConfiguration(long projectId, long syncId, List<String> labels, SprintReqVersion sprintReqVersion) {
        if (Objects.isNull(sprintReqVersion)) {
            return;
        }
        Map<String, String> gitLabScopeValuesByKeys = Mappings.Labels.getScopeValuesByKeysFromList(labels);
        List<String> gitLabNoScopeLabels = Mappings.Labels.getOnlyNoScopeLabelsFromList(labels);
        Mappings syncMappings = this.configurationService.getMappingsFromProjectAndSync(projectId, syncId);
        if (Objects.nonNull(syncMappings)) {
            sprintReqVersion.setCategory(this.getValuesToRegisterFromConf(syncMappings.getCategoryLabels(), gitLabScopeValuesByKeys, gitLabNoScopeLabels));
            sprintReqVersion.setCriticality(this.getValuesToRegisterFromConf(syncMappings.getCriticalityLabels(), gitLabScopeValuesByKeys, gitLabNoScopeLabels));
            sprintReqVersion.setStatus(this.getValuesToRegisterFromConf(syncMappings.getStatusLabels(), gitLabScopeValuesByKeys, gitLabNoScopeLabels));
        } else {
            sprintReqVersion.setCategory(null);
            sprintReqVersion.setCriticality(null);
            sprintReqVersion.setStatus(null);
        }
    }

    private String getValuesToRegisterFromConf(Mappings.Labels syncLabels, Map<String, String> gitLabScopeValuesByKeys, List<String> gitLabNoScopeLabels) {
        ArrayList toRegister = new ArrayList();
        List<String> scopeLabels = syncLabels.getScopeLabels();
        scopeLabels.forEach(label -> {
            String scope = (String)gitLabScopeValuesByKeys.get(label);
            if (Objects.nonNull(scope)) {
                toRegister.add(scope);
            }
        });
        syncLabels.getNoScopeLabels().forEach(label -> {
            if (gitLabNoScopeLabels.contains(label)) {
                toRegister.add(label);
            }
        });
        return String.join((CharSequence)", ", toRegister);
    }

    private void checkAndUpdateNameAndReference(SprintReqVersion sprintReqVersion, GitLabIssue gitLabIssue) {
        if (!sprintReqVersion.getName().equals(gitLabIssue.getTitle())) {
            sprintReqVersion.setName(gitLabIssue.getTitle());
        }
        String formattedReference = FieldMappingService.formatReference(gitLabIssue);
        if (!sprintReqVersion.getReference().equals(formattedReference)) {
            sprintReqVersion.setReference(formattedReference);
        }
    }

    private void checkAndUpdateDescription(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, SprintReqVersion sprintReqVersion, GitLabIssue gitLabIssue) {
        String currentDescription = FieldMappingService.checkAndUpdateDescriptionForGitLabInternalLinksAndFiles(gitLabRemoteSynchronisation, gitLabIssue.getDescription());
        if (!currentDescription.equals(sprintReqVersion.getDescription())) {
            sprintReqVersion.setDescription(currentDescription);
        }
    }

    public void updateSquashKnowSprintReqVersionPerimeterStatus(SynchronisationReport synchronisationReport, RemoteRequirementFinder.Result finderResult, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, GitLabInstanceType instanceType, List<GitLabIssue> issuesInSprint, Long squashSprintId) {
        Map<String, Optional<GitLabIssue>> unprocessedGitLabIssues = this.getUnprocessedGitLabIssuesForSprint(finderResult, gitLabRemoteSynchronisation, squashSprintId, instanceType);
        List<String> inCurrentPerimeterGitLabIssueIds = issuesInSprint.stream().map(GitLabIssue::getId).toList();
        List<String> outOfPerimeterGitLabIssueIds = GitLabIssueStatusPerimeterHelper.collectOutOfPerimeterGitLabIssueIds(unprocessedGitLabIssues);
        List<String> notFoundGitLabIssueIds = GitLabIssueStatusPerimeterHelper.collectNotFoundGitLabIssueIds(unprocessedGitLabIssues);
        this.updatePerimeterStatusForSprintReqVersion(inCurrentPerimeterGitLabIssueIds, squashSprintId, RemoteRequirementPerimeterStatus.IN_CURRENT_PERIMETER);
        this.updatePerimeterStatusForSprintReqVersion(outOfPerimeterGitLabIssueIds, squashSprintId, RemoteRequirementPerimeterStatus.OUT_OF_CURRENT_PERIMETER);
        this.updatePerimeterStatusForSprintReqVersion(notFoundGitLabIssueIds, squashSprintId, RemoteRequirementPerimeterStatus.NOT_FOUND);
        synchronisationReport.addToUnprocessedSprintTicketsCount(unprocessedGitLabIssues.size());
    }

    private Map<String, Optional<GitLabIssue>> getUnprocessedGitLabIssuesForSprint(RemoteRequirementFinder.Result finderResult, GitLabRemoteSynchronisation synchronisation, Long squashSprintId, GitLabInstanceType instanceType) {
        List synchronisedKeys = this.sprintRequirementSyncExtenderDao.findRemoteKeysBySprintIds(Collections.singletonList(squashSprintId));
        List<String> processedKeys = finderResult.allIssues.stream().map(GitLabEntityHelper::getKey).toList();
        BugTracker bugTracker = synchronisation.getRemoteSynchronisation().getServer();
        GitLabClient client = this.gitLabClientProvider.getGitLabClient(bugTracker.getId());
        return synchronisedKeys.stream().filter(key -> !processedKeys.contains(key)).collect(Collectors.toMap(unprocessedKey -> unprocessedKey, unprocessedKey -> client.fetchGitLabIssue(instanceType, (String)unprocessedKey, client)));
    }

    private void updatePerimeterStatusForSprintReqVersion(List<String> remoteReqKeys, Long squashSprintId, RemoteRequirementPerimeterStatus perimeterStatus) {
        if (!remoteReqKeys.isEmpty()) {
            this.sprintRequirementSyncExtenderDao.updatePerimeterStatus(remoteReqKeys, squashSprintId, perimeterStatus);
        }
    }
}

