/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabMilestone;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;

public class SyncedRequirementPathHelper {
    public static String getRelativePathFromWebPath(String webPath) {
        try {
            return SyncedRequirementPathHelper.getRelativePathFromWebPathUnsafe(webPath);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException ex) {
            throw new InvalidWebPathException("Cannot convert webPath into relative target folder path", ex);
        }
    }

    private static String getRelativePathFromWebPathUnsafe(String webPath) {
        int indexOfDiscriminator = webPath.indexOf("/-/");
        if (indexOfDiscriminator < 0) {
            throw new IllegalArgumentException("Received malformed webPath '%s'.".formatted(webPath));
        }
        return webPath.substring(1, indexOfDiscriminator).trim();
    }

    public static Set<String> getTargetPaths(GitLabRemoteSynchronisation synchronisation, List<GitLabIssue> gitLabIssues) {
        Set<String> foldersToCreate = new HashSet<String>();
        switch (synchronisation.getSyncedRequirementHierarchy()) {
            case ITERATION: {
                foldersToCreate = gitLabIssues.stream().map(GitLabIssue::getIteration).filter(Objects::nonNull).map(IterationDto::getIterationFolderPath).filter(Objects::nonNull).collect(Collectors.toSet());
                break;
            }
            case MILESTONE: {
                foldersToCreate = gitLabIssues.stream().map(GitLabIssue::getMilestone).filter(Objects::nonNull).map(GitLabMilestone::getTitleForPath).filter(Objects::nonNull).collect(Collectors.toSet());
                break;
            }
            case TREE: {
                foldersToCreate = gitLabIssues.stream().map(GitLabIssue::getWebPath).map(SyncedRequirementPathHelper::getRelativePathFromWebPath).collect(Collectors.toSet());
                break;
            }
        }
        return foldersToCreate;
    }

    public static String buildRequirementPath(GitLabRemoteSynchronisation synchronisation, GitLabIssue gitLabIssue, String requirementName, String rootFolderPath) {
        return String.join((CharSequence)"/", SyncedRequirementPathHelper.buildGroupFolderPath(synchronisation, gitLabIssue, rootFolderPath), requirementName);
    }

    public static String buildGroupFolderPath(@NotNull GitLabRemoteSynchronisation synchronisation, @NotNull GitLabIssue gitLabIssue, @NotNull String rootFolderPath) {
        switch (synchronisation.getSyncedRequirementHierarchy()) {
            case ITERATION: {
                IterationDto iteration = gitLabIssue.getIteration();
                if (iteration == null) break;
                return String.join((CharSequence)"/", rootFolderPath, iteration.getIterationFolderPath());
            }
            case MILESTONE: {
                GitLabMilestone milestone = gitLabIssue.getMilestone();
                if (milestone == null) break;
                return String.join((CharSequence)"/", rootFolderPath, milestone.getTitleForPath());
            }
            case TREE: {
                return String.join((CharSequence)"/", rootFolderPath, SyncedRequirementPathHelper.getRelativePathFromWebPath(gitLabIssue.getWebPath()));
            }
        }
        return rootFolderPath;
    }

    private SyncedRequirementPathHelper() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }

    static class InvalidWebPathException
    extends RuntimeException {
        public InvalidWebPathException(String message, RuntimeException cause) {
            super(message, cause);
        }
    }
}

