/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;

public class GitLabIssueCollector {
    private final Map<String, GitLabIssue> collectedIssues = new HashMap<String, GitLabIssue>();

    public void collectIssues(Collection<GitLabIssue> issues) {
        issues.forEach(issue -> {
            GitLabIssue gitLabIssue = this.collectedIssues.put(issue.getGlobalId(), (GitLabIssue)issue);
        });
    }

    public Optional<GitLabIssue> getIssue(String globalId) {
        return Optional.ofNullable(this.collectedIssues.get(globalId));
    }

    public ReadOnly readOnly() {
        return new ReadOnly(this);
    }

    public static class ReadOnly {
        private final GitLabIssueCollector collector;

        private ReadOnly(GitLabIssueCollector collector) {
            this.collector = collector;
        }

        public Optional<GitLabIssue> getIssue(String globalId) {
            return this.collector.getIssue(globalId);
        }

        public Object size() {
            return this.collector.collectedIssues.size();
        }
    }
}

