/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.FilteredBoardIssuesQueryBuilderAdapterCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.FilteredBoardIssuesQueryBuilderAdapterPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.IssuesQueryBuilderAdapterCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.IssuesQueryBuilderAdapterPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupBoardsPagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupEpicsPagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupIssueIdsPagingAdapterCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupIssueIdsPagingAdapterPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupIssuesPagingAdapterCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupIssuesPagingAdapterPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupLabelPagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupMembersPagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetGroupMilestonesPagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.pagingadapter.GetSingleGroupIterationsPagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabUserDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.MilestoneDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabBoardConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabBoardScopeConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabConverters;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabEpicConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIssueConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIssueCountConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIssueIdsConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIterationConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabLabelConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabMemberConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabMilestoneConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabBoardScope;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabInstanceType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.PerimeterType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.AbstractGitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.IssueFetchResult;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.GitLabIssueQueryFilterBuildersCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.issuesquery.GitLabIssueQueryFilterBuildersPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupBoardScopeQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupBoardsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupEpicsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssueCountCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssueCountQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssueIdsCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssueIdsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssueNotesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupFilteredBoardIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIdQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssueCountCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssueCountQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssueIdsCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssueIdsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIterationsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupLabelsQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupMembersQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupMilestonesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetSingleGroupIterationsQuery;

public class GitLabGroupClient
extends AbstractGitLabClient {
    public GitLabGroupClient(GitLabClient gitLabClient) {
        super(gitLabClient);
    }

    public Optional<String> getId(String perimeter) {
        GetGroupIdQuery query = GetGroupIdQuery.builder().fullPath(perimeter).build();
        return this.gitLabClient.executeAndConvert(query, (data, topLevelErrors) -> GitLabConverters.extractGroupId(data));
    }

    public List<GitLabUserDto> getMembers(String perimeter) {
        GetGroupMembersQuery.Builder queryBuilder = GetGroupMembersQuery.builder();
        queryBuilder.fullPath(perimeter);
        GetGroupMembersPagingAdapter pagingAdapter = new GetGroupMembersPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (data, topLevelErrors) -> GitLabMemberConverter.convertGroupGitLabUsers(data)));
    }

    public List<String> getLabels(String perimeter) {
        GetGroupLabelsQuery.Builder queryBuilder = GetGroupLabelsQuery.builder().fullPath(perimeter);
        GetGroupLabelPagingAdapter pagingAdapter = new GetGroupLabelPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (groupLabelsData, topLevelErrors) -> GitLabLabelConverter.convertGroupLabels(groupLabelsData)));
    }

    public List<MilestoneDto> getMilestones(String perimeter) {
        GetGroupMilestonesQuery.Builder queryBuilder = GetGroupMilestonesQuery.builder().fullPath(perimeter);
        GetGroupMilestonesPagingAdapter pagingAdapter = new GetGroupMilestonesPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (groupMilestonesData, topLevelErrors) -> GitLabMilestoneConverter.convertGroupMilestones(groupMilestonesData)));
    }

    public List<GitLabNamedReferenceDto> getEpics(String perimeter) {
        GetGroupEpicsQuery.Builder queryBuilder = GetGroupEpicsQuery.builder().fullPath(perimeter);
        GetGroupEpicsPagingAdapter pagingAdapter = new GetGroupEpicsPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (groupEpicsData, topLevelErrors) -> GitLabEpicConverter.convertGroupEpics(groupEpicsData)));
    }

    public List<IterationDto> getIterations(String perimeter) {
        GetGroupIterationsQuery query = GetGroupIterationsQuery.builder().fullPath(perimeter).build();
        GitLabIterationConverter.GroupIterationsFirstPageResult firstPageResult = this.gitLabClient.executeAndConvert(query, (data, topLevelErrors) -> GitLabIterationConverter.convertFirstPageGroupIterations(data));
        ArrayList<IterationDto> allIterations = new ArrayList<IterationDto>(firstPageResult.firstPageIterations);
        allIterations.addAll(this.getNextPagesGroupIterations(firstPageResult.endCursorsByGroupPath));
        return allIterations;
    }

    private List<IterationDto> getNextPagesGroupIterations(Map<String, Optional<String>> endCursorsByGroupPath) {
        ArrayList<IterationDto> results = new ArrayList<IterationDto>();
        endCursorsByGroupPath.forEach((groupPath, endCursor) -> {
            if (endCursor.isPresent()) {
                GetSingleGroupIterationsQuery.Builder queryBuilder = GetSingleGroupIterationsQuery.builder().fullPath((String)groupPath).afterCursor((String)endCursor.get());
                GetSingleGroupIterationsPagingAdapter pagingAdapter = new GetSingleGroupIterationsPagingAdapter(queryBuilder);
                List allIterations = this.gitLabClient.executeAndConvertAllPagesAfter(100, pagingAdapter, (data, topLevelErrors) -> GitLabIterationConverter.convertSingleGroupIterations(data), (String)endCursor.get()).stream().flatMap(Collection::stream).collect(Collectors.toList());
                results.addAll(allIterations);
            }
        });
        return results;
    }

    public List<GitLabNamedReferenceDto> getBoards(String perimeter) {
        GetGroupBoardsQuery.Builder queryBuilder = GetGroupBoardsQuery.builder().fullPath(perimeter);
        GetGroupBoardsPagingAdapter pagingAdapter = new GetGroupBoardsPagingAdapter(queryBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (data, topLevelErrors) -> GitLabBoardConverter.convertGroupBoards(data)));
    }

    public IssueFetchResult getIssues(GitLabRemoteSynchronisation synchronisation, boolean syncForSprint) {
        String perimeter = synchronisation.getPerimeter();
        GitLabInstanceType instanceType = this.getInstanceType();
        List<SynchronisationFilterValue> filterValues = synchronisation.getFilterValues();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            IssuesQueryBuilderAdapterPremium.GroupBuilderAdapterPremium builderAdapter = new IssuesQueryBuilderAdapterPremium.GroupBuilderAdapterPremium();
            builderAdapter.fullPath(perimeter);
            GitLabIssueQueryFilterBuildersPremium.appendFilters(builderAdapter, filterValues);
            return new IssueFetchResult(PerimeterType.GROUP, instanceType, this.fetchAllGroupIssuesPremium(builderAdapter.getBuilder()));
        }
        IssuesQueryBuilderAdapterCommunity.GroupBuilderAdapterCommunity builderAdapter = new IssuesQueryBuilderAdapterCommunity.GroupBuilderAdapterCommunity();
        builderAdapter.fullPath(perimeter);
        GitLabIssueQueryFilterBuildersCommunity.appendFilters(builderAdapter, filterValues);
        return new IssueFetchResult(PerimeterType.GROUP, instanceType, this.fetchAllGroupIssuesCommunity(builderAdapter.getBuilder()));
    }

    public IssueFetchResult getIssues(GitLabRemoteSynchronisation synchronisation) {
        return this.getIssues(synchronisation, false);
    }

    private List<GitLabIssue> fetchAllGroupIssuesPremium(GetGroupIssuesQuery.Builder preconfiguredBuilder) {
        GetGroupIssuesPagingAdapterPremium pagingAdapter = new GetGroupIssuesPagingAdapterPremium(preconfiguredBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (groupIssuesQueryData, topLevelErrors) -> GitLabIssueConverter.convertGroupIssuesPremium(groupIssuesQueryData)));
    }

    private List<GitLabIssue> fetchAllGroupIssuesCommunity(GetGroupIssuesCommunityQuery.Builder preconfiguredBuilder) {
        GetGroupIssuesPagingAdapterCommunity pagingAdapter = new GetGroupIssuesPagingAdapterCommunity(preconfiguredBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (groupIssuesQueryData, topLevelErrors) -> GitLabIssueConverter.convertGroupIssuesCommunity(groupIssuesQueryData)));
    }

    public IssueFetchResult getBoardIssues(GitLabRemoteSynchronisation synchronisation, boolean syncForSprints) {
        String boardId = syncForSprints ? GitLabRemoteSynchronisation.getSprintSelectValue(synchronisation.getRemoteSynchronisation()) : synchronisation.getSelectValue();
        if (boardId == null || boardId.isBlank()) {
            throw new UnsupportedOperationException("Cannot query group board issues without a valid board ID.");
        }
        GitLabInstanceType instanceType = this.getInstanceType();
        String perimeter = synchronisation.getPerimeter();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            GitLabBoardScope scope = this.getBoardScopePremium(synchronisation, boardId);
            FilteredBoardIssuesQueryBuilderAdapterPremium.GroupBuilderAdapterPremium builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterPremium.GroupBuilderAdapterPremium();
            GetGroupFilteredBoardIssuesQuery query = this.getFilteredBoardIssuesQueryBuilderPremium(perimeter, boardId, scope, builderAdapter).build();
            List<GitLabIssue> issuesWithoutNotes = this.getBoardIssuesAndMergeWithNextPages(scope, query, (data, topLevelErrors) -> GitLabIssueConverter.convertGroupBoardIssuesPremium(data), instanceType);
            List<GitLabIssue> issues = this.withNotesAdded(issuesWithoutNotes, perimeter, boardId, scope);
            return new IssueFetchResult(PerimeterType.GROUP, instanceType, issues);
        }
        FilteredBoardIssuesQueryBuilderAdapterCommunity.GroupBuilderAdapterCommunity builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterCommunity.GroupBuilderAdapterCommunity();
        GetGroupFilteredBoardIssuesCommunityQuery query = this.getFilteredBoardIssuesQueryBuilderCommunity(perimeter, boardId, builderAdapter).build();
        return new IssueFetchResult(PerimeterType.GROUP, instanceType, this.getBoardIssuesAndMergeWithNextPages(null, query, (data, topLevelErrors) -> GitLabIssueConverter.convertGroupBoardIssuesCommunity(data), instanceType));
    }

    private List<GitLabIssue> withNotesAdded(List<GitLabIssue> issues, String perimeter, String boardId, GitLabBoardScope scope) {
        Map<String, List<GitLabNote>> notesByIssueId = this.getBoardIssueNotesAndMergeWithNextPages(perimeter, boardId, scope);
        return issues.stream().map(issue -> issue.withNotes(notesByIssueId.getOrDefault(issue.getGlobalId(), issue.getNotes()))).toList();
    }

    private Map<String, List<GitLabNote>> getBoardIssueNotesAndMergeWithNextPages(String perimeter, String boardId, GitLabBoardScope scope) {
        FilteredBoardIssuesQueryBuilderAdapterPremium.GroupBuilderNotesAdapterPremium builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterPremium.GroupBuilderNotesAdapterPremium();
        GetGroupFilteredBoardIssueNotesQuery query = this.getFilteredBoardIssuesQueryBuilderPremium(perimeter, boardId, scope, builderAdapter).build();
        GitLabIssueConverter.BoardIssueNotesFirstPageResult result = this.gitLabClient.executeAndConvert(query, (data, topLevelErrors) -> GitLabIssueConverter.convertGroupBoardIssueNotesPremium(data));
        return result.notesByIssueId();
    }

    private GitLabBoardScope getBoardScopePremium(GitLabRemoteSynchronisation synchronisation, String boardId) {
        GetGroupBoardScopeQuery scopeQuery = GetGroupBoardScopeQuery.builder().fullPath(synchronisation.getPerimeter()).boardId(boardId).build();
        return this.gitLabClient.executeAndConvert(scopeQuery, (data, topLevelErrors) -> GitLabBoardScopeConverter.convertGroupBoardScope(data));
    }

    public GitLabInstanceType getInstanceType() {
        return this.isInstanceEnterpriseEdition() ? GitLabInstanceType.PREMIUM : GitLabInstanceType.COMMUNITY;
    }

    public int getGroupIssueCount(GitLabRemoteSynchronisation synchronisation, boolean syncForSprints) {
        String perimeter = synchronisation.getPerimeter();
        List<SynchronisationFilterValue> filterValues = syncForSprints ? GitLabRemoteSynchronisation.getSprintFilterValues(synchronisation.getRemoteSynchronisation()) : synchronisation.getFilterValues();
        GitLabInstanceType instanceType = this.getInstanceType();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            IssuesQueryBuilderAdapterPremium.GroupIssueCountBuilderAdapterPremium builderAdapter = new IssuesQueryBuilderAdapterPremium.GroupIssueCountBuilderAdapterPremium();
            builderAdapter.fullPath(perimeter);
            GitLabIssueQueryFilterBuildersPremium.appendFilters(builderAdapter, filterValues);
            GetGroupIssueCountQuery.Builder queryBuilder = builderAdapter.getBuilder();
            return this.fetchGroupIssueCount(queryBuilder);
        }
        IssuesQueryBuilderAdapterCommunity.GroupIssueCountBuilderAdapterCommunity builderAdapter = new IssuesQueryBuilderAdapterCommunity.GroupIssueCountBuilderAdapterCommunity();
        builderAdapter.fullPath(perimeter);
        GitLabIssueQueryFilterBuildersCommunity.appendFilters(builderAdapter, filterValues);
        GetGroupIssueCountCommunityQuery.Builder queryBuilder = builderAdapter.getBuilder();
        return this.fetchGroupIssueCountCommunity(queryBuilder);
    }

    private int fetchGroupIssueCount(GetGroupIssueCountQuery.Builder preconfiguredBuilder) {
        return this.gitLabClient.executeAndConvert(preconfiguredBuilder.build(), (queryData, topLevelErrors) -> GitLabIssueCountConverter.convertGroupIssueCount(queryData));
    }

    private int fetchGroupIssueCountCommunity(GetGroupIssueCountCommunityQuery.Builder preconfiguredBuilder) {
        return this.gitLabClient.executeAndConvert(preconfiguredBuilder.build(), (queryData, topLevelErrors) -> GitLabIssueCountConverter.convertGroupIssueCountCommunity(queryData));
    }

    public int getBoardIssueCount(GitLabRemoteSynchronisation synchronisation, boolean syncForSprints) {
        String perimeter = synchronisation.getPerimeter();
        String boardId = syncForSprints ? GitLabRemoteSynchronisation.getSprintSelectValue(synchronisation.getRemoteSynchronisation()) : synchronisation.getSelectValue();
        if (boardId == null || boardId.isBlank()) {
            throw new UnsupportedOperationException("Cannot query group board issue count without a valid board ID.");
        }
        GitLabInstanceType instanceType = this.getInstanceType();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            GitLabBoardScope scope = this.getBoardScopePremium(synchronisation, boardId);
            FilteredBoardIssuesQueryBuilderAdapterPremium.GroupBoardIssueCountQueryBuilderAdapterPremium builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterPremium.GroupBoardIssueCountQueryBuilderAdapterPremium();
            GetGroupFilteredBoardIssueCountQuery query = this.getFilteredBoardIssuesQueryBuilderPremium(perimeter, boardId, scope, builderAdapter).build();
            return this.fetchBoardIssueCount(query);
        }
        FilteredBoardIssuesQueryBuilderAdapterCommunity.GroupBoardIssueCountQueryBuilderAdapterCommunity builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterCommunity.GroupBoardIssueCountQueryBuilderAdapterCommunity();
        GetGroupFilteredBoardIssueCountCommunityQuery query = this.getFilteredBoardIssuesQueryBuilderCommunity(perimeter, boardId, builderAdapter).build();
        return this.fetchBoardIssueCountCommunity(query);
    }

    private int fetchBoardIssueCount(GetGroupFilteredBoardIssueCountQuery query) {
        return this.gitLabClient.executeAndConvert(query, (queryData, topLevelErrors) -> GitLabIssueCountConverter.convertGroupBoardIssueCount(queryData));
    }

    private int fetchBoardIssueCountCommunity(GetGroupFilteredBoardIssueCountCommunityQuery query) {
        return this.gitLabClient.executeAndConvert(query, (queryData, topLevelErrors) -> GitLabIssueCountConverter.convertGroupBoardIssueCountCommunity(queryData));
    }

    public List<String> getGroupIssueIds(GitLabRemoteSynchronisation synchronisation) {
        String perimeter = synchronisation.getPerimeter();
        List<SynchronisationFilterValue> filterValues = synchronisation.getFilterValues();
        GitLabInstanceType instanceType = this.getInstanceType();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            IssuesQueryBuilderAdapterPremium.GroupIssueIdsBuilderAdapterPremium builderAdapter = new IssuesQueryBuilderAdapterPremium.GroupIssueIdsBuilderAdapterPremium();
            builderAdapter.fullPath(perimeter);
            GitLabIssueQueryFilterBuildersPremium.appendFilters(builderAdapter, filterValues);
            GetGroupIssueIdsQuery.Builder queryBuilder = builderAdapter.getBuilder();
            return this.fetchGroupIssueIds(queryBuilder);
        }
        IssuesQueryBuilderAdapterCommunity.GroupIssueIdsBuilderAdapterCommunity builderAdapter = new IssuesQueryBuilderAdapterCommunity.GroupIssueIdsBuilderAdapterCommunity();
        builderAdapter.fullPath(perimeter);
        GitLabIssueQueryFilterBuildersCommunity.appendFilters(builderAdapter, filterValues);
        GetGroupIssueIdsCommunityQuery.Builder queryBuilder = builderAdapter.getBuilder();
        return this.fetchGroupIssueIdsCommunity(queryBuilder);
    }

    private List<String> fetchGroupIssueIds(GetGroupIssueIdsQuery.Builder preconfiguredBuilder) {
        GetGroupIssueIdsPagingAdapterPremium pagingAdapter = new GetGroupIssueIdsPagingAdapterPremium(preconfiguredBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (groupIssueIdsQueryData, topLevelErrors) -> GitLabIssueIdsConverter.convertGroupIssueIds(groupIssueIdsQueryData)));
    }

    private List<String> fetchGroupIssueIdsCommunity(GetGroupIssueIdsCommunityQuery.Builder preconfiguredBuilder) {
        GetGroupIssueIdsPagingAdapterCommunity pagingAdapter = new GetGroupIssueIdsPagingAdapterCommunity(preconfiguredBuilder);
        return this.flattened(this.gitLabClient.executeAndConvertAllPages(100, pagingAdapter, (groupIssueIdsQueryData, topLevelErrors) -> GitLabIssueIdsConverter.convertGroupIssueIdsCommunity(groupIssueIdsQueryData)));
    }

    public List<String> getBoardIssueIds(GitLabRemoteSynchronisation synchronisation) {
        String perimeter = synchronisation.getPerimeter();
        String boardId = synchronisation.getSelectValue();
        if (boardId == null || boardId.isBlank()) {
            throw new UnsupportedOperationException("Cannot query group board issue ids without a valid board ID.");
        }
        GitLabInstanceType instanceType = this.getInstanceType();
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            GitLabBoardScope scope = this.getBoardScopePremium(synchronisation, boardId);
            FilteredBoardIssuesQueryBuilderAdapterPremium.GroupBoardIssueIdsQueryBuilderAdapterPremium builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterPremium.GroupBoardIssueIdsQueryBuilderAdapterPremium();
            GetGroupFilteredBoardIssueIdsQuery query = this.getFilteredBoardIssuesQueryBuilderPremium(perimeter, boardId, scope, builderAdapter).build();
            return this.getBoardIssueIdsAndMergeWithNextPages(scope, query, (data, topLevelErrors) -> GitLabIssueIdsConverter.convertGroupBoardIssueIds(data), instanceType);
        }
        FilteredBoardIssuesQueryBuilderAdapterCommunity.GroupBoardIssueIdsQueryBuilderAdapterCommunity builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterCommunity.GroupBoardIssueIdsQueryBuilderAdapterCommunity();
        GetGroupFilteredBoardIssueIdsCommunityQuery query = this.getFilteredBoardIssuesQueryBuilderCommunity(perimeter, boardId, builderAdapter).build();
        return this.getBoardIssueIdsAndMergeWithNextPages(null, query, (data, topLevelErrors) -> GitLabIssueIdsConverter.convertGroupBoardIssueIdsCommunity(data), instanceType);
    }
}

