/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.rest.admin.jackson.model.FieldMappingDto;
import org.squashtest.tm.plugin.rest.admin.service.RestFieldMappingService;

@Service
@Transactional
public class RestFieldMappingServiceImpl
implements RestFieldMappingService {
    @Inject
    private PluginRequirementDao dao;
    @Inject
    private ConfigurationService configurationService;

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public FieldMapping updateFieldMapping(long projectId, String fieldMappingId, FieldMappingDto fieldMappingDto) {
        Configuration configuration = this.dao.getConfigurationForProject(projectId);
        FieldMapping fieldMapping = configuration.getFieldMapping(fieldMappingId);
        if (fieldMapping.isLocked()) {
            throw new RuntimeException("Attempted to modify an uneditable field mapping '" + fieldMappingId + "'.");
        }
        fieldMapping.setJiraField(fieldMappingDto.getJiraField());
        fieldMapping.setSquashField(fieldMappingDto.getSquashField());
        this.dao.storeConfigurationForProject(projectId, configuration);
        return fieldMapping;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void createFieldMapping(long projectId, FieldMapping fieldMapping) {
        this.configurationService.addFieldMapping(projectId, fieldMapping);
    }
}

