/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ValueMappingDto;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.project.GenericProjectFinder;

@RestApiController
@UseDefaultRestApiConfiguration
@ConditionalOnClass(name={"org.squashtest.tm.plugin.rest.admin.SquashAdminApiConditionalInterface"})
public class RestValueMappingController
extends BaseRestController {
    @Inject
    private ConfigurationService pluginService;
    @Inject
    private GenericProjectFinder genericProjectFinder;

    @GetMapping(value={"/projects/{id}/available-value-mappings"})
    public ResponseEntity<Map<String, List<String>>> getListAvailableValueMappingByProject(@PathVariable(value="id") Long projectId) {
        Map<String, List<String>> valueMappings = this.makeValueMappingsList(projectId);
        return ResponseEntity.ok(valueMappings);
    }

    @GetMapping(value={"/projects/{id}/value-mappings-script"})
    public ResponseEntity<ValueMappingDto> getValueMappingScriptByProject(@PathVariable(value="id") Long projectId) {
        Configuration conf = this.pluginService.getConfigurationForProject(projectId);
        ValueMappingDto res = new ValueMappingDto(conf.getYamlFieldvalueMapping());
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/projects/{id}/value-mappings-script"})
    public ResponseEntity<ValueMappingDto> editValueMappingByProject(@PathVariable(value="id") Long projectId, @RequestBody ValueMappingDto valueMappingScript) {
        this.pluginService.updateValueMappings(projectId, valueMappingScript.getScript());
        return ResponseEntity.ok((Object)valueMappingScript);
    }

    private Map<String, List<String>> makeValueMappingsList(Long projectId) {
        LinkedHashMap<String, List<String>> valueMappings = new LinkedHashMap<String, List<String>>();
        GenericProject p = this.genericProjectFinder.findById(projectId.longValue());
        InfoList categories = p.getRequirementCategories();
        List<String> strCrits = Arrays.asList("critical", "major", "minor", "undefined");
        List<String> strStats = Arrays.asList("work_in_progress", "under_review", "approved", "obsolete");
        ArrayList<String> strCats = new ArrayList<String>(categories.getItems().size());
        boolean canLowercase = categories.getCode().equals("DEF_REQ_CAT");
        for (InfoListItem item : categories.getItems()) {
            String code = canLowercase ? item.getCode().toLowerCase() : item.getCode();
            strCats.add(code);
        }
        valueMappings.put("criticality", strCrits);
        valueMappings.put("category", strCats);
        valueMappings.put("status", strStats);
        return valueMappings;
    }
}

