/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.domain.CredentialStatusDto;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.service.servers.CredentialsProvider;

@Service
@Transactional(readOnly=true)
public class ClientProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientProvider.class);
    @Inject
    private Provider<JiraClient> provider;
    @Inject
    private CredentialsProvider credentialsProvider;

    public JiraClient createAuthenticatedClient(BugTracker tracker) {
        String trackerName = tracker.getName();
        LOGGER.debug("creating authenticated client for bugtracker '{}'", (Object)trackerName);
        Optional appLevelCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)tracker);
        Optional userCredentials = this.credentialsProvider.getCurrentUserCredentials((ThirdPartyServer)tracker);
        JiraClient client = (JiraClient)this.provider.get();
        if (appLevelCredentials.isPresent()) {
            Credentials credentials = (Credentials)appLevelCredentials.get();
            this.initializeClientCredentials(tracker, trackerName, client, credentials);
        } else if (userCredentials.isPresent()) {
            Credentials credentials = (Credentials)userCredentials.get();
            this.initializeClientCredentials(tracker, trackerName, client, credentials);
        } else {
            this.logAndThrowCredentialsError(trackerName);
        }
        LOGGER.debug("client authenticated and ready");
        return client;
    }

    public JiraClient getJiraClient(JiraRemoteSynchronisation synchronisation) {
        return synchronisation.getOwner() != null ? this.createUserClient(synchronisation.getServer(), synchronisation.getOwner().getLogin()) : this.createAppLevelClient(synchronisation.getServer());
    }

    public JiraClient createAppLevelClient(BugTracker tracker) {
        LOGGER.debug("creating authenticated app Level client for bugtracker '{}'", (Object)tracker.getName());
        Optional appLevelCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)tracker);
        return this.createClientWithCredentials(tracker, appLevelCredentials);
    }

    public JiraClient createUserClient(BugTracker tracker, String username) {
        LOGGER.debug("creating authenticated user client for bugtracker '{}'", (Object)tracker.getName());
        Optional userCredentials = this.credentialsProvider.getUserCredentials((ThirdPartyServer)tracker, username);
        return this.createClientWithCredentials(tracker, userCredentials);
    }

    private JiraClient createClientWithCredentials(BugTracker tracker, Optional<Credentials> credentials) {
        String trackerName = tracker.getName();
        JiraClient client = (JiraClient)this.provider.get();
        if (credentials.isPresent()) {
            this.initializeClientCredentials(tracker, trackerName, client, credentials.get());
        } else {
            this.logAndThrowCredentialsError(trackerName);
        }
        LOGGER.debug("client authenticated and ready");
        return client;
    }

    private void initializeClientCredentials(BugTracker tracker, String trackerName, JiraClient client, Credentials credentials) {
        if (!this.areCredentialsCorrect(credentials)) {
            this.logAndThrowCredentialsError(trackerName);
        }
        client.initialize(tracker, credentials);
    }

    public CredentialStatusDto getCredentialsStatus(BugTracker tracker) {
        boolean hasAppLevelCredentials = this.credentialsProvider.hasAppLevelCredentials((ThirdPartyServer)tracker);
        boolean hasUserLevelCredentials = this.credentialsProvider.hasCredentials((ThirdPartyServer)tracker);
        return new CredentialStatusDto(hasUserLevelCredentials, hasAppLevelCredentials, tracker.getAuthenticationProtocol());
    }

    private boolean areCredentialsCorrect(Credentials credentials) {
        return JiraClient.PROTOCOLS.contains(credentials.getImplementedProtocol());
    }

    private void logAndThrowCredentialsError(String trackerName) {
        String errorMsg = String.format("The configuration for the JIRA server '%s' in SquashTM is incomplete. It is required to configure a Basic Authentication  scheme as an application-level credential prior using this plugin", trackerName);
        throw new RuntimeException(errorMsg);
    }
}

