/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.importer;

import io.jsonwebtoken.lang.Collections;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jirasync.com.atlassian.jira.rest.client.api.domain.Attachment;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueField;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueType;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.event.SyncRequirementCreation;
import org.squashtest.tm.domain.event.SyncRequirementUpdate;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.LocaleWithFallback;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.jirasync.domain.EpicIssueType;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.RequirementReference;
import org.squashtest.tm.plugin.jirasync.helpers.JiraHelper;
import org.squashtest.tm.plugin.jirasync.helpers.JiraValue;
import org.squashtest.tm.plugin.jirasync.helpers.SquashHelper;
import org.squashtest.tm.plugin.jirasync.importer.ImporterState;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.SynchronisationEffectiveConfiguration;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteRequirementKeys;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.container.RequirementVersionInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.HighLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.importer.ExcelRowReaderUtils;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component(value="squash.tm.plugin.jirasync.importer")
@Scope(value="prototype")
public class JiraRequirementImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraRequirementImporter.class);
    private static final Set<String> BUILTIN_FIELDS = new HashSet<String>();
    private static final String ATLASSIAN = "atlassian";
    private final PluginRequirementDao pluginRequirementDao;
    private final FacilityImpl importer;
    private final RequirementSyncExtenderDao reqsyncDao;
    private final SquashHelper squashHelper;
    private final JiraHelper jiraHelper;
    private final InternationalizationHelper lang;
    private final RequirementLibraryNavigationService navService;
    private final InternationalizationHelper inHelper;
    private final PluginFinderService pluginFinderService;
    private final MilestoneDao milestoneDao;
    @PersistenceContext
    private EntityManager entityManager;
    private BugTracker server;
    private Project project;
    private SynchronisationEffectiveConfiguration conf;
    private ImporterState state;
    private Locale locale;
    private Map<String, RequirementReference> knownRequirementPaths;
    private Map<String, RequirementSyncExtender> extenderByKey;
    private Map<Long, List<String>> milestoneLabelsByRequirement;
    private List<String> knownEpicKeys;

    static {
        BuiltinSquashField[] builtinSquashFieldArray = BuiltinSquashField.values();
        int n = builtinSquashFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinSquashField field = builtinSquashFieldArray[n2];
            BUILTIN_FIELDS.add(field.toString());
            ++n2;
        }
    }

    public JiraRequirementImporter(PluginRequirementDao pluginRequirementDao, FacilityImpl importer, RequirementSyncExtenderDao reqsyncDao, SquashHelper squashHelper, JiraHelper jiraHelper, InternationalizationHelper lang, RequirementLibraryNavigationService navService, InternationalizationHelper inHelper, PluginFinderService pluginFinderService, MilestoneDao milestoneDao) {
        this.pluginRequirementDao = pluginRequirementDao;
        this.importer = importer;
        this.reqsyncDao = reqsyncDao;
        this.squashHelper = squashHelper;
        this.jiraHelper = jiraHelper;
        this.lang = lang;
        this.navService = navService;
        this.inHelper = inHelper;
        this.pluginFinderService = pluginFinderService;
        this.milestoneDao = milestoneDao;
    }

    public void setServer(BugTracker server) {
        this.server = server;
    }

    public void setProject(Project p) {
        this.project = p;
    }

    public void setState(ImporterState state) {
        this.state = state;
    }

    public void setConfiguration(SynchronisationEffectiveConfiguration conf) {
        this.conf = conf;
    }

    public void configure() {
        this.locale = LocaleWithFallback.getLocaleWithFallback();
        this.squashHelper.initForProject(this.project, this.conf.getValueMappings());
    }

    public Map<Issue, RequirementVersionInstruction> importJiraTickets(Iterable<Issue> jiraIssues, JiraRemoteSynchronisation jiraRemoteSynchronisation, RemoteRequirementKeys desynchronisedIssueKeys, Map<String, String> issuesDescription) {
        ArrayList<String> keys = new ArrayList<String>(desynchronisedIssueKeys.getToUpdate());
        boolean isJiraCloudServer = this.isJiraCloudServer(jiraRemoteSynchronisation);
        this.cacheKnownRequirementsData(new HashSet<String>(keys), jiraRemoteSynchronisation.getRemoteSynchronisation());
        HashMap<RequirementVersionInstruction, Issue> instructionIssueMap = new HashMap<RequirementVersionInstruction, Issue>();
        String rootFolderPath = this.navService.getPathAsString(jiraRemoteSynchronisation.getTargetFolderId().longValue());
        for (Issue issue : jiraIssues) {
            ArrayList<Attachment> att = issue.getAttachments() != null ? issue.getAttachments() : new ArrayList<Attachment>();
            String htmlDescription = this.buildHtmlDescription(isJiraCloudServer, att, issuesDescription.get(issue.getKey()));
            RequirementVersionInstruction instruction = this.buildInstruction(issue, jiraRemoteSynchronisation, htmlDescription, rootFolderPath);
            instructionIssueMap.put(instruction, issue);
        }
        Map<Issue, RequirementVersionInstruction> squashReqs = this.processInstructions(instructionIssueMap, jiraRemoteSynchronisation);
        this.processAudit(squashReqs.values());
        this.state.addProcessedReqs(keys);
        return squashReqs;
    }

    private Map<Issue, RequirementVersionInstruction> processInstructions(Map<RequirementVersionInstruction, Issue> instructionIssueMap, JiraRemoteSynchronisation remoteSynchronisation) {
        HashMap<Issue, RequirementVersionInstruction> squashReqs = new HashMap<Issue, RequirementVersionInstruction>();
        RequirementVersionInstructionContainer container = new RequirementVersionInstructionContainer(new ArrayList<RequirementVersionInstruction>(instructionIssueMap.keySet()));
        container.executeInstructions((Facility)this.importer, this.project);
        for (Map.Entry<RequirementVersionInstruction, Issue> entry : instructionIssueMap.entrySet()) {
            RequirementVersionInstruction instruction = entry.getKey();
            Issue issue = entry.getValue();
            LogTrain logs = instruction.getLogTrain();
            if (logs.hasCriticalErrors()) {
                this.logCriticalErrors(logs);
                this.state.setHadFailureOnFieldImport(true);
                continue;
            }
            if (instruction.getMode() == ImportMode.CREATE) {
                this.processExtenderCreation(instruction, issue, remoteSynchronisation);
            } else {
                this.processExtenderUpdate(instruction, issue, remoteSynchronisation);
            }
            squashReqs.put(issue, instruction);
        }
        return squashReqs;
    }

    public boolean isJiraCloudServer(JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        return jiraRemoteSynchronisation.getServer().getUrl().contains(ATLASSIAN);
    }

    public String buildHtmlDescription(boolean isJiraCloudServer, Iterable<Attachment> att, String issueDescription) {
        ArrayList<String> nameAndUrl = new ArrayList<String>();
        HashMap<String, String> imageURIByJiraImageIdMap = new HashMap<String, String>();
        for (Attachment attachment : att) {
            this.appendDescriptionAttachmentLinkTags(isJiraCloudServer, nameAndUrl, imageURIByJiraImageIdMap, attachment);
        }
        String msg = this.buildDescriptionAttachmentMessage(nameAndUrl);
        if (isJiraCloudServer) {
            issueDescription = this.appendSourceInTheImagesOfIssueDescription(imageURIByJiraImageIdMap, issueDescription);
        }
        String descriptionWithAttachments = msg + String.join((CharSequence)",", nameAndUrl);
        return issueDescription + descriptionWithAttachments;
    }

    private String buildDescriptionAttachmentMessage(ArrayList<String> nameAndUrl) {
        Object msg = nameAndUrl.isEmpty() ? " " : "<br/>" + this.inHelper.internationalize("henix.jirasync.label.Attachments", this.locale) + ":  ";
        return msg;
    }

    private void appendDescriptionAttachmentLinkTags(boolean isJiraCloudServer, ArrayList<String> nameAndUrl, Map<String, String> imageURIByJiraImageIdMap, Attachment attachment) {
        if (this.isAttachmentImageFromJiraCloud(isJiraCloudServer, attachment)) {
            String imageURI = attachment.getContentUri().toString();
            imageURIByJiraImageIdMap.put(this.extractImageIdFromURI(imageURI), imageURI);
        }
        String name = attachment.getFilename();
        URI url = attachment.getContentUri();
        String element = "<a href='" + String.valueOf(url) + "' target='_blank'>" + name + "</a>";
        nameAndUrl.add(element);
    }

    private String appendSourceInTheImagesOfIssueDescription(Map<String, String> imageURIByJiraImageIdMap, String issueDescription) {
        Set<String> imageIds = imageURIByJiraImageIdMap.keySet();
        Document document = Jsoup.parse((String)issueDescription);
        Elements elements = document.select("img");
        elements.forEach(element -> {
            String imageSrc = element.attr("src");
            imageIds.forEach(imageId -> {
                if (imageSrc.contains((CharSequence)imageId)) {
                    element.attr("src", (String)imageURIByJiraImageIdMap.get(imageId));
                }
            });
        });
        return document.body().html();
    }

    private boolean isAttachmentImageFromJiraCloud(boolean isJiraCloudServer, Attachment attachment) {
        return attachment.getMimeType().contains("image") && isJiraCloudServer;
    }

    private String extractImageIdFromURI(String imageURI) {
        String[] split = imageURI.split("/");
        return split[split.length - 1];
    }

    private RequirementVersionInstruction buildInstruction(Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation, String htmlDescription, String rootFolderPath) {
        RequirementVersionInstruction instruction = this.createInstruction(issue, jiraRemoteSynchronisation, htmlDescription, rootFolderPath);
        if (this.knows(issue.getKey()) && jiraRemoteSynchronisation.isSynchronisationEnable()) {
            instruction.setMode(ImportMode.UPDATE);
            this.addExistingMilestonesInInstruction(instruction);
        } else {
            instruction.setMode(ImportMode.CREATE);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("attempting to create requirement version '" + ((RequirementVersionTarget)instruction.getTarget()).getPath() + "'");
            }
        }
        return instruction;
    }

    private void processExtenderCreation(RequirementVersionInstruction instruction, Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("import went with no critical errors " + instruction.getLogTrain().getEntries().size());
        }
        if (jiraRemoteSynchronisation.isSynchronisationEnable()) {
            Requirement req = instruction.getRequirementVersion().getRequirement();
            RequirementSyncExtender extender = new RequirementSyncExtender();
            this.updateExtender(extender, issue, jiraRemoteSynchronisation);
            if (req.getSyncExtender() != null) {
                throw new IllegalArgumentException("this was supposed to be a new requirement !");
            }
            req.setSyncExtender(extender);
            extender.setRequirement(req);
            this.entityManager.persist((Object)extender);
        }
    }

    private void processExtenderUpdate(RequirementVersionInstruction instruction, Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("import went with no critical errors " + instruction.getLogTrain().getEntries().size());
        }
        RequirementSyncExtender extender = this.extenderByKey.get(issue.getKey());
        this.updateExtender(extender, issue, jiraRemoteSynchronisation);
    }

    private void addExistingMilestonesInInstruction(RequirementVersionInstruction instruction) {
        RequirementVersionTarget reqVersionTarget = (RequirementVersionTarget)instruction.getTarget();
        RequirementTarget reqTarget = reqVersionTarget.getRequirement();
        Long reqId = this.knownRequirementPaths.get(reqTarget.getRemoteKey()).getRequirementId();
        String[] existingMilestoneNames = (String[])this.milestoneLabelsByRequirement.getOrDefault(reqId, Collections.emptyList()).toArray(String[]::new);
        instruction.setMilestones(existingMilestoneNames);
    }

    private RequirementVersionInstruction createInstruction(Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation, String htmlDescription, String rootFolderPath) {
        RequirementVersion version = new RequirementVersion();
        version.setVersionNumber(1);
        new Requirement(version);
        HashMap<String, String> customFields = new HashMap<String, String>();
        this.populate(version, customFields, issue);
        version.getPropertySetter().setDescription(ExcelRowReaderUtils.escapeHTMLInsideTags((String)htmlDescription));
        String issueKey = issue.getKey();
        Object path = "";
        if (this.knows(issueKey)) {
            path = this.knownRequirementPaths.get(issueKey).getRequirementPath();
        } else {
            String escvname = version.getName().replace("/", "\\/");
            path = rootFolderPath + "/" + escvname;
        }
        return this.wrapAsInstruction(version, customFields, (String)path, issue.getKey(), jiraRemoteSynchronisation, issue.getIssueType());
    }

    private void populate(RequirementVersion version, Map<String, String> cufs, Issue jiraIssue) {
        Map<String, SynchronisationEffectiveConfiguration.EffectiveMapping> mapping = this.conf.getFieldMappings();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("parsing issue '" + jiraIssue.getKey() + "'");
        }
        for (Map.Entry<String, SynchronisationEffectiveConfiguration.EffectiveMapping> entry : mapping.entrySet()) {
            String squashField = entry.getKey();
            SynchronisationEffectiveConfiguration.EffectiveMapping jiraField = entry.getValue();
            if (!jiraField.invalid()) {
                JiraValue jiraValue = null;
                try {
                    jiraValue = this.jiraHelper.getFieldValue(jiraIssue, jiraField);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("processing value '" + jiraValue.toString() + "' for mapped field '" + jiraField.toString() + "'");
                    }
                    if (BUILTIN_FIELDS.contains(squashField)) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("setting builtin property '" + squashField + "' with value '" + jiraValue.toString() + "'");
                        }
                        this.squashHelper.setBuiltinProperty(version, BuiltinSquashField.valueOf(squashField), jiraValue);
                        continue;
                    }
                    String strValue = this.squashHelper.getCustomfieldValue(squashField, jiraValue);
                    cufs.put(squashField, strValue);
                }
                catch (IllegalArgumentException ex) {
                    this.state.setHadFailureOnFieldImport(true);
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.error("an error occured while settings value for field '" + squashField + "' : " + ex.getMessage());
                }
                continue;
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("skipping SquashTM field " + squashField + " because the corresponding jira field doesn't exist");
        }
    }

    private RequirementVersionInstruction wrapAsInstruction(RequirementVersion version, Map<String, String> cufs, String path, String key, JiraRemoteSynchronisation jiraRemoteSynchronisation, IssueType issueType) {
        boolean isEpicToSyncInHighLevel = this.checkIsEpicToSynchronizedInHighLevel(key, issueType);
        HighLevelRequirementTarget treq = isEpicToSyncInHighLevel ? new HighLevelRequirementTarget(path) : new RequirementTarget(path);
        treq.setRemoteKey(key);
        treq.setRemoteSynchronisationId(Long.valueOf(jiraRemoteSynchronisation.getId()));
        RequirementVersionTarget tversion = new RequirementVersionTarget((RequirementTarget)treq, null);
        RequirementVersionInstruction instr = new RequirementVersionInstruction(tversion, version);
        tversion.setVersion(Integer.valueOf(1));
        for (Map.Entry<String, String> cuf : cufs.entrySet()) {
            instr.addCustomField(cuf.getKey(), cuf.getValue());
        }
        return instr;
    }

    private boolean checkIsEpicToSynchronizedInHighLevel(String key, IssueType issueType) {
        List<String> epicTypes = EpicIssueType.getAllEpicIssueTypes();
        boolean isJiraEpic = epicTypes.contains(issueType.getName());
        boolean isPremiumPluginInstalled = this.pluginFinderService.isPremiumPluginInstalled();
        boolean isHighLevelAlreadyExistInSynchro = this.knownEpicKeys.contains(key);
        return isJiraEpic && (isPremiumPluginInstalled || isHighLevelAlreadyExistInSynchro);
    }

    private void updateExtender(RequirementSyncExtender ext, Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        ext.setServer(this.server);
        ext.setRemoteProjectId(issue.getProject().getKey());
        ext.setRemoteSynchronisation(jiraRemoteSynchronisation.getRemoteSynchronisation());
        ext.setRemoteReqId(issue.getKey());
        ext.setRemoteLastUpdated(issue.getUpdateDate().toDate());
        IssueField parent = issue.getField("parent");
        if (parent == null || !issue.getIssueType().isSubtask()) {
            ext.setRemoteParentId(null);
        } else {
            JSONObject jsonParent = (JSONObject)parent.getValue();
            String key = jsonParent.optString("key");
            ext.setRemoteParentId(key);
        }
        String url = StringUtils.appendIfMissing((String)this.server.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "browse/" + issue.getKey();
        try {
            ext.setRemoteUrl(new URI(url).toURL());
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOGGER.warn("could not set url correctly for issue '{}'. Error message is: {}.", (Object)issue.getKey(), (Object)ex.getMessage());
        }
    }

    private void processAudit(Collection<RequirementVersionInstruction> instructions) {
        this.pluginRequirementDao.flush();
        String login = UserContextHolder.getUsername();
        HashSet<Long> versionIds = new HashSet<Long>();
        for (RequirementVersionInstruction instr : instructions) {
            SyncRequirementCreation evt;
            ImportMode mode = instr.getMode();
            RequirementVersion version = instr.getRequirementVersion();
            versionIds.add(version.getId());
            if (mode == ImportMode.CREATE) {
                evt = new SyncRequirementCreation(version, login);
                evt.setSource(version.getRequirement().getSyncExtender().getRemoteUrl().toString());
                this.pluginRequirementDao.persist((RequirementAuditEvent)evt);
                continue;
            }
            evt = new SyncRequirementUpdate(version, login);
            evt.setSource(version.getRequirement().getSyncExtender().getRemoteUrl().toString());
            this.pluginRequirementDao.persist((RequirementAuditEvent)evt);
        }
        this.pluginRequirementDao.removeAllCreationEvent(versionIds);
    }

    private void logCriticalErrors(LogTrain logs) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("some critical errors occured when importing that requirement :");
            for (LogEntry log : logs.getEntries()) {
                if (log.getStatus() != ImportStatus.FAILURE) continue;
                RequirementVersionTarget target = (RequirementVersionTarget)log.getTarget();
                LOGGER.trace(target.getPath() + " : " + this.lang.getMessage(log.getI18nError(), log.getErrorArgs(), log.getI18nError(), this.locale));
            }
        }
    }

    private void cacheKnownRequirementsData(Set<String> keys, RemoteSynchronisation remoteSynchronisation) {
        this.knownRequirementPaths = this.pluginRequirementDao.findKnownRequirements(keys, remoteSynchronisation);
        if (this.knownRequirementPaths.isEmpty()) {
            this.extenderByKey = Collections.emptyMap();
            this.milestoneLabelsByRequirement = Collections.emptyMap();
            this.knownEpicKeys = Collections.emptyList();
            return;
        }
        Set knownRequirementIds = this.knownRequirementPaths.values().stream().map(RequirementReference::getRequirementId).collect(Collectors.toSet());
        this.extenderByKey = this.reqsyncDao.findByRemoteKeysAndSyncId(this.knownRequirementPaths.keySet(), Long.valueOf(remoteSynchronisation.getId()));
        this.milestoneLabelsByRequirement = this.milestoneDao.findRequirementMilestoneLabelsByReqIds(knownRequirementIds);
        this.knownEpicKeys = this.pluginRequirementDao.findKnownEpicKeys(remoteSynchronisation.getId());
    }

    private boolean knows(String issueKey) {
        return this.knownRequirementPaths.containsKey(issueKey);
    }
}

