/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.client;

import gitlabbt.org.glassfish.jersey.client.ClientRequest;
import gitlabbt.org.glassfish.jersey.innate.spi.MessageBodyWorkersSettable;
import gitlabbt.org.glassfish.jersey.internal.inject.InjectionManager;
import gitlabbt.org.glassfish.jersey.internal.inject.Providers;
import gitlabbt.org.glassfish.jersey.internal.util.collection.Ref;
import gitlabbt.org.glassfish.jersey.message.MessageBodyWorkers;
import gitlabbt.org.glassfish.jersey.model.internal.RankedComparator;
import jakarta.inject.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class RequestProcessingInitializationStage
implements Function<ClientRequest, ClientRequest> {
    private final Provider<Ref<ClientRequest>> requestRefProvider;
    private final MessageBodyWorkers workersProvider;
    private final Iterable<WriterInterceptor> writerInterceptors;
    private final Iterable<ReaderInterceptor> readerInterceptors;

    public RequestProcessingInitializationStage(Provider<Ref<ClientRequest>> requestRefProvider, MessageBodyWorkers workersProvider, InjectionManager injectionManager) {
        this.requestRefProvider = requestRefProvider;
        this.workersProvider = workersProvider;
        this.writerInterceptors = Collections.unmodifiableList(StreamSupport.stream(Providers.getAllProviders(injectionManager, WriterInterceptor.class, new RankedComparator()).spliterator(), false).collect(Collectors.toList()));
        this.readerInterceptors = Collections.unmodifiableList(StreamSupport.stream(Providers.getAllProviders(injectionManager, ReaderInterceptor.class, new RankedComparator()).spliterator(), false).collect(Collectors.toList()));
    }

    @Override
    public ClientRequest apply(ClientRequest requestContext) {
        ((Ref)this.requestRefProvider.get()).set(requestContext);
        requestContext.setWorkers(this.workersProvider);
        requestContext.setWriterInterceptors(this.writerInterceptors);
        requestContext.setReaderInterceptors(this.readerInterceptors);
        if (requestContext.getEntity() != null) {
            this.setWorkers(requestContext.getEntity());
        }
        return requestContext;
    }

    private void setWorkers(Object entity) {
        if (MessageBodyWorkersSettable.class.isInstance(entity)) {
            ((MessageBodyWorkersSettable)entity).setMessageBodyWorkers(this.workersProvider);
        } else if (Collection.class.isInstance(entity)) {
            Iterator it = ((Collection)entity).iterator();
            while (it.hasNext()) {
                this.setWorkers(it.next());
            }
        }
    }
}

