/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Label;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class LabelsApi
extends AbstractApi {
    public LabelsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Label> getProjectLabels(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectLabels(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<Label> getProjectLabels(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Label>(this, Label.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
    }

    public Stream<Label> getProjectLabelsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectLabels(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Label getProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
        return response.readEntity(Label.class);
    }

    public Optional<Label> getOptionalProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getProjectLabel(projectIdOrPath, labelIdOrName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Label createProjectLabel(Object projectIdOrPath, Label labelProperties) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(labelProperties.getForm(true));
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
        return response.readEntity(Label.class);
    }

    public Label updateProjectLabel(Object projectIdOrPath, Object labelIdOrName, Label labelConfig) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(labelConfig.getForm(false));
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
        return response.readEntity(Label.class);
    }

    public void deleteProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
    }

    public Label subscribeProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName), "subscribe");
        return response.readEntity(Label.class);
    }

    public Label unsubscribeProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName), "unsubscribe");
        return response.readEntity(Label.class);
    }

    public List<Label> getGroupLabels(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupLabels(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<Label> getGroupLabels(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Label>(this, Label.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels");
    }

    public Stream<Label> getGroupLabelsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupLabels(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Label getGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
        return response.readEntity(Label.class);
    }

    public Optional<Label> getOptionalGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getGroupLabel(groupIdOrPath, labelIdOrName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Label createGroupLabel(Object groupIdOrPath, Label labelProperties) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(labelProperties.getForm(true));
        Response response = this.post(Response.Status.CREATED, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels");
        return response.readEntity(Label.class);
    }

    public Label updateGroupLabel(Object groupIdOrPath, Object labelIdOrName, Label labelConfig) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(labelConfig.getForm(false));
        Response response = this.putWithFormData(Response.Status.OK, formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
        return response.readEntity(Label.class);
    }

    public void deleteGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
    }

    public Label subscribeGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), "groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName), "subscribe");
        return response.readEntity(Label.class);
    }

    public Label unsubscribeGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), "groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName), "unsubscribe");
        return response.readEntity(Label.class);
    }

    @Deprecated
    public List<Label> getLabels(Object projectIdOrPath) throws GitLabApiException {
        return this.getLabels(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    @Deprecated
    public List<Label> getLabels(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
        return response.readEntity(new GenericType<List<Label>>(){});
    }

    @Deprecated
    public Pager<Label> getLabels(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Label>(this, Label.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
    }

    @Deprecated
    public Stream<Label> getLabelsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getLabels(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    @Deprecated
    public Label createLabel(Object projectIdOrPath, String name, String color, String description) throws GitLabApiException {
        return this.createLabel(projectIdOrPath, name, color, description, null);
    }

    @Deprecated
    public Label createLabel(Object projectIdOrPath, String name, String color) throws GitLabApiException {
        return this.createLabel(projectIdOrPath, name, color, null, null);
    }

    @Deprecated
    public Label createLabel(Object projectIdOrPath, String name, String color, Integer priority) throws GitLabApiException {
        return this.createLabel(projectIdOrPath, name, color, null, priority);
    }

    @Deprecated
    public Label createLabel(Object projectIdOrPath, String name, String color, String description, Integer priority) throws GitLabApiException {
        Label labelProperties = new Label().withName(name).withColor(color).withDescription(description).withPriority(priority);
        return this.createProjectLabel(projectIdOrPath, labelProperties);
    }

    @Deprecated
    public Label updateLabelName(Object projectIdOrPath, String name, String newName, String description, Integer priority) throws GitLabApiException {
        return this.updateLabel(projectIdOrPath, name, newName, null, description, priority);
    }

    @Deprecated
    public Label updateLabelColor(Object projectIdOrPath, String name, String color, String description, Integer priority) throws GitLabApiException {
        return this.updateLabel(projectIdOrPath, name, null, color, description, priority);
    }

    @Deprecated
    public Label updateLabel(Object projectIdOrPath, String name, String newName, String color, String description, Integer priority) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("new_name", newName).withParam("color", color).withParam("description", description).withParam("priority", priority);
        Response response = this.put(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
        return response.readEntity(Label.class);
    }

    @Deprecated
    public void deleteLabel(Object projectIdOrPath, String name) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true);
        this.delete(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
    }

    @Deprecated
    public Label subscribeLabel(Object projectIdOrPath, Long labelId) throws GitLabApiException {
        return this.subscribeProjectLabel(projectIdOrPath, labelId);
    }

    @Deprecated
    public Label unsubscribeLabel(Object projectIdOrPath, Long labelId) throws GitLabApiException {
        return this.unsubscribeProjectLabel(projectIdOrPath, labelId);
    }
}

