/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import java.util.Arrays;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.rest.jackson.model.IterationDto;
import org.squashtest.tm.plugin.rest.validators.helper.RestNodeValidationHelper;

@Component
public class IterationValidationHelper
extends RestNodeValidationHelper {
    public void checkProject(IterationDto dto) {
        if (dto.getProjectId() == null) {
            throw new IllegalArgumentException("Programmatic error, you must provide a not null project id to add an iteration");
        }
        Project project = (Project)this.entityManager.find(Project.class, (Object)dto.getProjectId());
        if (project == null) {
            throw new IllegalArgumentException("Programmatic error, you must provide a valid project id to add an iteration");
        }
    }

    public void checkAndAssignStatus(Errors errors, IterationDto iterationDto) {
        IterationStatus status = iterationDto.getStatus();
        if (status != null) {
            if (!Arrays.asList(IterationStatus.values()).contains(status)) {
                errors.rejectValue("status", "invalid type", "Invalid iteration status for this project");
            }
        } else {
            iterationDto.setStatus(IterationStatus.defaultValue());
        }
    }
}

