/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.CustomFieldVisitor;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.NumericField;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.RichTextField;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.exception.sync.SynchronizedFieldException;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.validators.helper.RestNodeValidationHelper;
import org.squashtest.tm.service.customfield.CustomFieldValueChangerService;

public class CustomFieldValueValidationHelper
extends RestNodeValidationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldValueValidationHelper.class);
    private static final DateFormat DATE_TESTER = new SimpleDateFormat("yyyy-MM-dd");
    public static final String UPDATED_BY_SYNCHRO = "can only be updated by synchronization for this requirement.";
    public static final String CUSTOM_FIELDS = "customFields";
    public static final String INVALID_VALUE = "invalid value";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private CustomFieldValueChangerService customFieldValueChangerService;
    private BindableEntity bindableEntity;
    private Long projectId;
    private Long entityId;
    private List<CustomField> customFields;
    private List<CustomFieldValueDto> dtos;
    private Errors errors;

    static {
        DATE_TESTER.setLenient(false);
    }

    public CustomFieldValueValidationHelper() {
    }

    public CustomFieldValueValidationHelper(CustomFieldValueChangerService customFieldValueChangerService, BindableEntity bindableEntity, Long projectId, List<CustomField> customFields, List<CustomFieldValueDto> dtos, Errors errors) {
        this.customFieldValueChangerService = customFieldValueChangerService;
        this.bindableEntity = bindableEntity;
        this.projectId = projectId;
        this.customFields = customFields;
        this.dtos = dtos;
        this.errors = errors;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public void setBindableEntity(BindableEntity bindableEntity) {
        this.bindableEntity = bindableEntity;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    public void setDtos(List<CustomFieldValueDto> dtos) {
        this.dtos = dtos;
    }

    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    public static List<CustomField> collectCustomFields(List<CustomFieldValue> values) {
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        for (CustomFieldValue cfv : values) {
            customFields.add(cfv.getCustomField());
        }
        return customFields;
    }

    public void validate() {
        this.checkCufCode();
        this.checkCufValue();
    }

    private void checkCufCode() {
        for (CustomFieldValueDto dto : this.dtos) {
            CustomField customField;
            String code = dto.getCode();
            if (StringUtils.isBlank((CharSequence)code)) {
                this.errors.rejectValue(CUSTOM_FIELDS, "Mandatory custom field code", "The code is mandatory to post custom field values.");
            }
            if ((customField = this.locateByCode(this.customFields, code)) == null) {
                String message = "The custom field with code : %s is not bound for entities of type %s in project %d".formatted(code, this.bindableEntity, this.projectId);
                this.errors.rejectValue(CUSTOM_FIELDS, "Not bound custom field", message);
            }
            if (this.entityId == null || !this.checkIfCufIsSynchronized(customField)) continue;
            String syncMessage = "The custom field %s %s".formatted(customField.getCode(), UPDATED_BY_SYNCHRO);
            this.errors.rejectValue(CUSTOM_FIELDS, "Synchronized custom field", syncMessage);
        }
    }

    private boolean checkIfCufIsSynchronized(CustomField customField) {
        try {
            this.customFieldValueChangerService.checkIfCufIsSynchronized(this.bindableEntity, this.entityId, customField.getCode());
        }
        catch (SynchronizedFieldException e) {
            LOGGER.info("Custom field {} {}", new Object[]{customField.getCode(), UPDATED_BY_SYNCHRO, e});
            return true;
        }
        return false;
    }

    private void checkCufValue() {
        for (CustomFieldValueDto dto : this.dtos) {
            String code = dto.getCode();
            RawValue value = dto.getValue();
            CustomField customField = this.locateByCode(this.customFields, code);
            if (customField == null) continue;
            if (!customField.isOptional() && value != null && value.isEmpty()) {
                this.errors.rejectValue(CUSTOM_FIELDS, "Mandatory custom field value", "The value is mandatory to post custom field values. If you want to leave the default value for this field, just omit the whole custom field object from json");
            }
            CustomFieldValidationVisitor visitor = new CustomFieldValidationVisitor(this.errors, dto);
            customField.accept((CustomFieldVisitor)visitor);
        }
    }

    private CustomField locateByCode(List<CustomField> customFields, String code) {
        for (CustomField cf : customFields) {
            if (!cf.getCode().equals(code)) continue;
            return cf;
        }
        return null;
    }

    private static final class CustomFieldValidationVisitor
    implements CustomFieldVisitor {
        private Errors errors;
        private CustomFieldValueDto dto;
        private RawValue value;

        public CustomFieldValidationVisitor(Errors errors, CustomFieldValueDto dto) {
            this.errors = errors;
            this.dto = dto;
            this.value = dto.getValue();
        }

        public void visit(SingleSelectField singleSelectField) {
            this.checkOption(singleSelectField);
            this.checkArityForSingleValueCuf((CustomField)singleSelectField);
        }

        public void visit(CustomField customField) {
            this.checkArityForSingleValueCuf(customField);
            if (customField.getInputType() == InputType.DATE_PICKER) {
                this.checkDate(customField);
            }
            if (customField.getInputType() == InputType.CHECKBOX) {
                this.checkBoolean(customField);
            }
            if (customField.getInputType() == InputType.NUMERIC) {
                this.visit((NumericField)customField);
            }
        }

        public void visit(RichTextField richTextField) {
            this.checkArityForSingleValueCuf((CustomField)richTextField);
        }

        public void visit(MultiSelectField multiSelectField) {
            this.checkArityForMultiValueCuf(multiSelectField);
        }

        public void visit(NumericField numericField) {
            this.checkArityForSingleValueCuf((CustomField)numericField);
            String numberAsString = this.value.getValue();
            try {
                new BigDecimal(numberAsString);
            }
            catch (NumberFormatException numberFormatException) {
                String message = "The cuf %s identified by code %s is a numeric value cuf. The value provided is not convertible to number".formatted(numericField.getLabel(), numericField.getCode(), this.value.getValue());
                this.errors.rejectValue(CustomFieldValueValidationHelper.CUSTOM_FIELDS, "custom field numeric value", message);
            }
        }

        private void checkArityForMultiValueCuf(MultiSelectField customField) {
            if (this.value != null && (this.value.getValues() == null || this.value.getValues().isEmpty())) {
                String message = "The cuf %s identified by code %s is a multi value cuf. You provided standard attribute with value : %s. Please provide json array.".formatted(customField.getLabel(), customField.getCode(), this.value.getValue());
                this.errors.rejectValue(CustomFieldValueValidationHelper.CUSTOM_FIELDS, "custom field multi value", message);
            }
        }

        private void checkArityForSingleValueCuf(CustomField customField) {
            if (this.value == null || this.value.getValues() == null || this.value.getValues().isEmpty()) {
                return;
            }
            String message = "The cuf %s identified by code %s is a single value cuf. You provided a json array with values : %s. Please provide a standard attribute not an array.".formatted(customField.getLabel(), customField.getCode(), this.value.getValues());
            this.errors.rejectValue(CustomFieldValueValidationHelper.CUSTOM_FIELDS, "custom field single value", message);
        }

        private void checkOption(SingleSelectField singleSelectField) {
            List options = singleSelectField.getOptions();
            boolean valid = false;
            for (CustomFieldOption option : options) {
                if (!option.getLabel().equals(this.dto.getValue().getValue())) continue;
                valid = true;
            }
            if (!valid) {
                this.errors.rejectValue(CustomFieldValueValidationHelper.CUSTOM_FIELDS, "Mandatory custom field value", "Unknown value for list : " + singleSelectField.getCode() + " . Custom field option are identified by label.");
            }
        }

        private void checkDate(CustomField cuf) {
            if (this.value == null || this.value.getValue().isEmpty()) {
                return;
            }
            String strDate = this.value.getValue();
            try {
                DATE_TESTER.parse(strDate);
            }
            catch (ParseException parseException) {
                this.errors.rejectValue(CustomFieldValueValidationHelper.CUSTOM_FIELDS, CustomFieldValueValidationHelper.INVALID_VALUE, "The field '" + cuf.getLabel() + "' identified by label '" + cuf.getLabel() + "' accepts dates using format 'yyyy-mm-dd' only");
            }
        }

        private void checkBoolean(CustomField cuf) {
            boolean check;
            if (this.value == null) {
                return;
            }
            String strBool = this.value.getValue().toLowerCase();
            boolean bl = check = strBool.equals(CustomFieldValueValidationHelper.TRUE) || strBool.equals(CustomFieldValueValidationHelper.FALSE);
            if (!check) {
                this.errors.rejectValue(CustomFieldValueValidationHelper.CUSTOM_FIELDS, CustomFieldValueValidationHelper.INVALID_VALUE, "The field '" + cuf.getLabel() + "' identified by label '" + cuf.getLabel() + "' accepts boolean 'true' or 'false'");
            }
        }
    }
}

