/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.internal.dto.resultimport.ExecutionResultDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestDto;

@Component
public class ResultPostValidator
implements Validator {
    private static final String CODE_REQUIRED_ATTRIBUTE = "required attribute";
    private static final String CODE_INVALID_ATTRIBUTE = "invalid attribute";
    private static final String TESTS_ARRAY = "tests[%d]";

    public boolean supports(Class<?> clazz) {
        return ExecutionResultDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ExecutionResultDto externalPipelineResultDto = (ExecutionResultDto)target;
        Optional.ofNullable(externalPipelineResultDto.getAutomatedTestSuite()).ifPresent(suite -> this.validateAutomatedTestSuite(externalPipelineResultDto, errors));
        this.validateTests(externalPipelineResultDto, errors);
    }

    private void validateTests(ExecutionResultDto externalPipelineResultDto, Errors errors) {
        if (externalPipelineResultDto.getTests() == null || externalPipelineResultDto.getTests().isEmpty()) {
            errors.rejectValue("tests", CODE_REQUIRED_ATTRIBUTE, "The tests attribute is required");
        } else {
            int testIndex = 0;
            while (testIndex < externalPipelineResultDto.getTests().size()) {
                TestDto test = (TestDto)externalPipelineResultDto.getTests().get(testIndex);
                this.validateTest(errors, test, testIndex);
                ++testIndex;
            }
            this.checkForDuplicateReferenceDatasetTuples(externalPipelineResultDto.getTests(), errors);
        }
    }

    private void validateTest(Errors errors, TestDto test, int testIndex) {
        if (!StringUtils.hasText((String)test.getReference())) {
            errors.rejectValue(TESTS_ARRAY.formatted(testIndex) + ".reference", CODE_REQUIRED_ATTRIBUTE, "The reference attribute is required");
        }
        if (!StringUtils.hasText((String)test.getStatus())) {
            errors.rejectValue(TESTS_ARRAY.formatted(testIndex) + ".status", CODE_REQUIRED_ATTRIBUTE, "The status attribute is required");
        } else if (this.isInvalidStatus(test.getStatus(), AutomatedExecutionExtender.getImportLegalStatusSet())) {
            errors.rejectValue(TESTS_ARRAY.formatted(testIndex) + ".status", CODE_INVALID_ATTRIBUTE, "The status attribute is invalid, allowed values are: " + String.valueOf(AutomatedExecutionExtender.getImportLegalStatusSet().stream().map(Enum::name).toList()));
        }
    }

    private void checkForDuplicateReferenceDatasetTuples(List<TestDto> tests, Errors errors) {
        HashSet<CallSite> uniqueTuples = new HashSet<CallSite>();
        for (TestDto test : tests) {
            String datasetName = test.getDatasetName() != null ? test.getDatasetName() : "";
            String tuple = test.getReference() + ":" + datasetName;
            if (uniqueTuples.add((CallSite)((Object)tuple))) continue;
            errors.rejectValue(TESTS_ARRAY.formatted(tests.indexOf(test)), CODE_INVALID_ATTRIBUTE, "The reference and dataset name combination must be unique");
        }
    }

    private void validateAutomatedTestSuite(ExecutionResultDto externalPipelineResultDto, Errors errors) {
        String suiteStatus = externalPipelineResultDto.getAutomatedTestSuite().getStatus();
        if (suiteStatus != null && this.isInvalidStatus(suiteStatus, AutomatedSuite.getImportLegalStatusSet())) {
            errors.rejectValue("automatedTestSuite.status", CODE_INVALID_ATTRIBUTE, "The status attribute is invalid, allowed values are: " + String.valueOf(AutomatedSuite.getImportLegalStatusSet().stream().map(Enum::name).toList()));
        }
    }

    private boolean isInvalidStatus(String candidateStatus, Set<? extends Enum<?>> allowedStatuses) {
        return allowedStatuses.stream().map(Enum::name).noneMatch(candidateStatus::equals);
    }
}

