/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.plugin.rest.jackson.model.RestActionWordDto;
import org.squashtest.tm.plugin.rest.validators.EntityValidator;

@Component
public class ActionWordPatchValidator
extends EntityValidator {
    private static final String CODE_NON_PATCHABLE_ATTRIBUTE = "non patchable attribute";
    private static final String MESSAGE_ATTRIBUTE_CANNOT_BE_MODIFIED = "The attribute cannot be modified.";
    private static final String MESSAGE_ATTRIBUTE_CANNOT_BE_PATCHED = "Only attributes belonging to the action word itself can be patched. The attribute %1$s cannot be patched. Use direct url to the %1$s instead.";
    private static final String TEST_CASES = "testCases";
    private static final String PARAMETERS = "parameters";
    private static final String PROJECT = "project";
    private static final String WORD = "word";

    public boolean supports(Class<?> clazz) {
        return RestActionWordDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        RestActionWordDto patch = (RestActionWordDto)target;
        this.checkEntityExist(errors, ActionWord.class, patch.getId());
        this.checkForbiddenPatchAttributes(errors, patch);
    }

    private void checkForbiddenPatchAttributes(Errors errors, RestActionWordDto patch) {
        if (patch.getWord() != null) {
            errors.rejectValue(WORD, CODE_NON_PATCHABLE_ATTRIBUTE, MESSAGE_ATTRIBUTE_CANNOT_BE_MODIFIED);
        }
        if (patch.getParameters() != null) {
            errors.rejectValue(PARAMETERS, CODE_NON_PATCHABLE_ATTRIBUTE, MESSAGE_ATTRIBUTE_CANNOT_BE_PATCHED.formatted(PARAMETERS));
        }
        if (patch.getTestCases() != null) {
            errors.rejectValue(TEST_CASES, CODE_NON_PATCHABLE_ATTRIBUTE, MESSAGE_ATTRIBUTE_CANNOT_BE_PATCHED.formatted(TEST_CASES));
        }
        if (patch.getProject() != null) {
            errors.rejectValue(PROJECT, CODE_NON_PATCHABLE_ATTRIBUTE, MESSAGE_ATTRIBUTE_CANNOT_BE_PATCHED.formatted(PROJECT));
        }
    }
}

