/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetParamValueDto;
import org.squashtest.tm.plugin.rest.repository.RestDatasetRepository;
import org.squashtest.tm.plugin.rest.service.RestDatasetService;
import org.squashtest.tm.service.internal.repository.hibernate.ParameterDaoImpl;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.DatasetModificationService;

@Service
@Transactional
public class RestDatasetServiceImpl
implements RestDatasetService {
    @Inject
    private RestDatasetRepository restDatasetRepository;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private DatasetModificationService datasetModificationService;
    @Inject
    private ParameterDaoImpl parameterDao;

    @Override
    @Transactional(readOnly=true)
    public Dataset getOne(long id) throws AccessDeniedException {
        Dataset dataset = this.getDataset(id);
        TestCase testCase = dataset.getTestCase();
        if (this.permissionEvaluationService.canRead((Object)testCase)) {
            return dataset;
        }
        throw new AccessDeniedException("Access denied");
    }

    private Dataset getDataset(long id) {
        Dataset dataset = this.restDatasetRepository.retrieveById(id);
        if (dataset == null) {
            throw new EntityNotFoundException("The dataset with id : " + id + " do not exist.");
        }
        return dataset;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#testCaseId,'org.squashtest.tm.domain.testcase.TestCase' , 'READ')")
    public Page<Dataset> findAllByTestCaseId(long testCaseId, Pageable pageable) {
        return this.restDatasetRepository.findByTestCase_Id(testCaseId, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#datasetDto.getReferencedTestCase().getId(),'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE')")
    public Dataset addDataset(DatasetDto datasetDto, List<Parameter> listAllParamByIdTc) {
        Dataset dataset = new Dataset();
        ArrayList<DatasetParamValueDto> listParamValueDto = new ArrayList<DatasetParamValueDto>(datasetDto.getValueDtos());
        dataset.setName(datasetDto.getName());
        Iterator<Parameter> it = listAllParamByIdTc.iterator();
        while (it.hasNext()) {
            String newParamValue = "";
            Parameter paramByIdTc = it.next();
            for (DatasetParamValueDto paramValueDto : listParamValueDto) {
                if (!paramValueDto.getParameterId().equals(paramByIdTc.getId())) continue;
                newParamValue = paramValueDto.getValue();
            }
            DatasetParamValue dpv = new DatasetParamValue(paramByIdTc, dataset, newParamValue);
            dataset.addParameterValue(dpv);
        }
        this.datasetModificationService.persist(dataset, datasetDto.getReferencedTestCase().getId().longValue());
        return dataset;
    }

    @Override
    public Dataset modifyDataset(DatasetDto datasetDto, Long datasetId) {
        Dataset dataset = this.getDataset(datasetId);
        this.checkWritePermissionOnTestCase(dataset.getTestCase().getId());
        if (datasetDto.isHasName()) {
            dataset.setName(datasetDto.getName());
        }
        ArrayList<DatasetParamValueDto> listParamValueDto = new ArrayList<DatasetParamValueDto>(datasetDto.getValueDtos());
        if (datasetDto.isHasParamValue()) {
            List<DatasetParamValue> listParamValueById = this.restDatasetRepository.findParamValueByIdDataset(datasetId);
            for (DatasetParamValue paramValueById : listParamValueById) {
                for (DatasetParamValueDto elt : listParamValueDto) {
                    if (!elt.getParameterId().equals(paramValueById.getParameter().getId())) continue;
                    paramValueById.setParamValue(elt.getValue());
                }
            }
        }
        return dataset;
    }

    @Override
    public void deleteDataset(Long datasetId) {
        Dataset dataset = this.getDataset(datasetId);
        this.checkWritePermissionOnTestCase(dataset.getTestCase().getId());
        this.datasetModificationService.removeById(datasetId.longValue());
    }

    @Override
    public List<Parameter> findAllParametersByTc(Long id) {
        return this.parameterDao.findAllParametersByTestCase(id);
    }

    private void checkWritePermissionOnTestCase(Long testCaseId) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(testCaseId), Permissions.WRITE.name(), TestCase.class.getName());
    }
}

