/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.core.exception.ProgrammingError;
import org.squashtest.tm.plugin.rest.jackson.model.RestUploadedData;
import org.squashtest.tm.plugin.rest.service.RestAttachmentService;
import org.squashtest.tm.plugin.rest.service.helper.AttachmentContentFilterHelper;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class RestAttachmentServiceImpl
implements RestAttachmentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAttachmentServiceImpl.class);
    @Inject
    private AttachmentManagerService attachmentService;
    @Inject
    private AttachmentContentFilterHelper filterHelper;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private MilestoneDao milestoneDao;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Attachment findById(long id) {
        try {
            return this.attachmentService.findAttachment(Long.valueOf(id));
        }
        catch (IllegalArgumentException | AccessDeniedException e) {
            LOGGER.error("Error while retrieving attachment with id: " + id, e);
            throw new EntityNotFoundException("The attachment with id: " + id + " does not exist.");
        }
    }

    @Override
    public Page<Attachment> findPagedAttachments(AttachmentHolder attached, Pageable pageable) {
        return this.attachmentService.findPagedAttachments(attached, pageable);
    }

    @Override
    public Attachment addAttachment(long attachmentListId, RawAttachment upload, EntityType holderType) throws IOException {
        if (!this.filterHelper.isTypeAllowed(upload)) {
            throw new IllegalArgumentException(upload.getName() + " : file type not supported");
        }
        this.milestoneDao.checkBlockingMilestonesOnAttachmentList(holderType, attachmentListId);
        AttachmentDto dto = this.attachmentService.addAttachment(attachmentListId, upload, holderType);
        return this.findById(dto.getId());
    }

    @Override
    public Attachment renameAttachment(long attachmentId, String newName) {
        if (newName != null && !newName.isEmpty()) {
            this.attachmentService.renameAttachment(attachmentId, newName);
            return this.findById(attachmentId);
        }
        throw new IllegalArgumentException("name can not be empty or null");
    }

    @Override
    public List<Attachment> addAttachments(AttachmentHolder holder, List<MultipartFile> files, EntityType holderType) {
        long listId = holder.getAttachmentList().getId();
        return files.stream().map(file -> {
            try {
                RestUploadedData data = new RestUploadedData(file.getInputStream(), file.getOriginalFilename(), file.getSize());
                return this.addAttachment(listId, data, holderType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void deleteAttachments(AttachmentHolder holder, List<Long> attachmentIds, EntityType holderType) throws IOException {
        this.attachmentService.removeListOfAttachments(holder.getAttachmentList().getId().longValue(), attachmentIds, holder.toEntityReference(), holderType);
    }

    @Override
    public AttachmentHolder findHolder(String owner, long id) {
        return this.findHolderWithPermission(owner, id, "READ").entrySet().iterator().next().getValue();
    }

    @Override
    public Map<EntityType, AttachmentHolder> findHolderWithPermission(String owner, long id, String permission) {
        switch (owner) {
            case "test-steps": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, TestStep.class.getName());
                ActionTestStep testStep = (ActionTestStep)this.entityManager.find(ActionTestStep.class, (Object)id);
                return Collections.singletonMap(EntityType.ACTION_TEST_STEP, testStep);
            }
            case "campaigns": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, Campaign.class.getName());
                Campaign campaign = (Campaign)this.entityManager.find(Campaign.class, (Object)id);
                return Collections.singletonMap(EntityType.CAMPAIGN, campaign);
            }
            case "campaign-folders": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, CampaignFolder.class.getName());
                CampaignFolder folder = (CampaignFolder)this.entityManager.find(CampaignFolder.class, (Object)id);
                return Collections.singletonMap(EntityType.CAMPAIGN_FOLDER, folder);
            }
            case "executions": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, Execution.class.getName());
                Execution execution = (Execution)this.entityManager.find(Execution.class, (Object)id);
                return Collections.singletonMap(EntityType.EXECUTION, execution);
            }
            case "execution-steps": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, ExecutionStep.class.getName());
                ExecutionStep executionStep = (ExecutionStep)this.entityManager.find(ExecutionStep.class, (Object)id);
                return Collections.singletonMap(EntityType.EXECUTION_STEP, executionStep);
            }
            case "projects": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, Project.class.getName());
                Project project = (Project)this.entityManager.find(Project.class, (Object)id);
                return Collections.singletonMap(EntityType.PROJECT, project);
            }
            case "iterations": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, Iteration.class.getName());
                Iteration iteration = (Iteration)this.entityManager.find(Iteration.class, (Object)id);
                return Collections.singletonMap(EntityType.ITERATION, iteration);
            }
            case "requirement-folders": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, RequirementFolder.class.getName());
                RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)id);
                return Collections.singletonMap(EntityType.REQUIREMENT_FOLDER, requirementFolder);
            }
            case "requirement-versions": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, RequirementVersion.class.getName());
                RequirementVersion requirementVersion = (RequirementVersion)this.entityManager.find(RequirementVersion.class, (Object)id);
                return Collections.singletonMap(EntityType.REQUIREMENT_VERSION, requirementVersion);
            }
            case "test-cases": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, TestCase.class.getName());
                TestCase testCase = (TestCase)this.entityManager.find(TestCase.class, (Object)id);
                return Collections.singletonMap(EntityType.TEST_CASE, testCase);
            }
            case "test-case-folders": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, TestCaseFolder.class.getName());
                TestCaseFolder testCaseFolder = (TestCaseFolder)this.entityManager.find(TestCaseFolder.class, (Object)id);
                return Collections.singletonMap(EntityType.TEST_CASE_FOLDER, testCaseFolder);
            }
            case "test-suites": {
                this.permissionService.checkPermission(Collections.singletonList(id), permission, TestSuite.class.getName());
                TestSuite testSuite = (TestSuite)this.entityManager.find(TestSuite.class, (Object)id);
                return Collections.singletonMap(EntityType.TEST_SUITE, testSuite);
            }
            case "automated-suites": {
                AutomatedSuite automatedSuite = (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)id);
                return Collections.singletonMap(EntityType.AUTOMATED_SUITE, automatedSuite);
            }
        }
        throw new ProgrammingError("the url : " + owner + "/{id}/attachments does not exist, please double check it");
    }
}

