/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;

public interface RestGenericProjectRepository
extends JpaRepository<GenericProject, Long> {
    public GenericProject getReferenceById(Long var1);

    public GenericProject getOneByName(String var1);

    public Page<GenericProject> findAll(Pageable var1);

    @Query(value="select distinct p from GenericProject p left join p.milestones m\n where (:milestoneId is null or m.id = :milestoneId)\n and (:milestoneLabel is null or m.label = :milestoneLabel)\n")
    public Page<GenericProject> findAllWithMilestones(@Param(value="milestoneId") Long var1, @Param(value="milestoneLabel") String var2, Pageable var3);

    @Query(value="select distinct pt from ProjectTemplate pt left join pt.milestones m\n where (:milestoneId is null or m.id = :milestoneId)\n and (:milestoneLabel is null or m.label = :milestoneLabel)\n")
    public Page<GenericProject> findAllTemplates(@Param(value="milestoneId") Long var1, @Param(value="milestoneLabel") String var2, Pageable var3);

    @Query(value="select distinct p from Project p left join p.milestones m\n where p.id in :projectIds\n and (:milestoneId is null or m.id = :milestoneId)\n and (:milestoneLabel is null or m.label = :milestoneLabel)\n")
    public Page<GenericProject> findProjectByIdAndMilestones(@Param(value="milestoneId") Long var1, @Param(value="milestoneLabel") String var2, @Param(value="projectIds") Collection<Long> var3, Pageable var4);

    @Query(value="select nodes from RequirementLibraryNode nodes where nodes.project.id = :projectId")
    public Page<RequirementLibraryNode<Resource>> findRequirementLibraryAllContent(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select nodes from Project p join p.requirementLibrary rl join rl.rootContent nodes where p.id = :projectId")
    public Page<RequirementLibraryNode<Resource>> findRequirementLibraryRootContent(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select nodes from TestCaseLibraryNode nodes where nodes.project.id = :projectId")
    public Page<TestCaseLibraryNode> findTestCaseLibraryAllContent(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select nodes from Project p join p.testCaseLibrary tcl join tcl.rootContent nodes where p.id = :projectId")
    public Page<TestCaseLibraryNode> findTestCaseLibraryRootContent(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select nodes from CampaignLibraryNode nodes where nodes.project.id = :projectId")
    public Page<CampaignLibraryNode> findCampaignLibraryAllContent(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select nodes from Project p join p.campaignLibrary cl join cl.rootContent nodes where p.id = :projectId")
    public Page<CampaignLibraryNode> findCampaignLibraryRootContent(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select reqs from Requirement reqs where reqs.project.id = :projectId")
    public Page<Requirement> findAllRequirementByProjectId(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select tcs from TestCase tcs where tcs.project.id = :projectId")
    public Page<TestCase> findAllTestCaseByProjectId(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select cams from Campaign cams where cams.project.id = :projectId")
    public Page<Campaign> findAllCampaignByProjectId(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select project.id, project.name from Project project where project.id in :projectIds group by project.id")
    public List<Object[]> findNamesByProjectIds(@Param(value="projectIds") List<Long> var1);

    @Query(value="select crln from CustomReportLibraryNode crln where crln.library.id = :projectId and crln.entityType <> 'LIBRARY'")
    public Page<CustomReportLibraryNode> findAllCustomReportLibraryByProjectId(@Param(value="projectId") long var1, Pageable var3);

    @Query(value="select crln from CustomReportLibraryNode crln where crln.id in :crlnIds and crln.entityType <> 'LIBRARY'")
    public Page<CustomReportLibraryNode> findAllCustomReportLibraryByCustomReportLibraryNodeIds(@Param(value="crlnIds") List<Long> var1, Pageable var2);
}

