/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.deserializer;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Identified;

@Component
public class JsonCrawler {
    @PersistenceContext
    private EntityManager entityManager;

    public String asMandatoryString(JsonNode jsonNode, String ... path) {
        JsonNode targetNode = this.getMandatoryTargetNode(jsonNode, path);
        String value = targetNode.asText();
        if (StringUtils.isBlank((CharSequence)value)) {
            this.missingMandatory(jsonNode, path);
        }
        return value;
    }

    public Long asMandatoryLong(JsonNode jsonNode, String ... path) {
        JsonNode targetNode = this.getMandatoryTargetNode(jsonNode, path);
        Long value = targetNode.asLong();
        return value;
    }

    private JsonNode getMandatoryTargetNode(JsonNode jsonNode, String[] path) {
        JsonPointer jsonPointer = this.computePointer(path);
        JsonNode targetNode = jsonNode.at(jsonPointer);
        if (targetNode == null) {
            this.missingMandatory(jsonNode, path);
        }
        return targetNode;
    }

    private void missingMandatory(JsonNode jsonNode, String[] path) {
        String message = "Mandatory attribute %s in object %s is missing.".formatted(Arrays.toString(path), jsonNode.asText());
        throw new IllegalArgumentException(message);
    }

    public boolean hasValidId(JsonNode jsonNode) {
        return this.hasValidId(jsonNode, new String[0]);
    }

    public boolean hasValidId(JsonNode jsonNode, String ... path) {
        JsonPointer jsonPointer = this.computeIdPointer(path);
        JsonNode node = jsonNode.at(jsonPointer);
        if (node == null) {
            return false;
        }
        if (!node.canConvertToLong()) {
            String message = "Invalid Id format. All ids must be provided as numbers";
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public <T extends Identified> T findMandatoryEntity(JsonNode jsonNode, Class<T> clazz) {
        return this.findMandatoryEntity(jsonNode, clazz, new String[0]);
    }

    public <T extends Identified> T findMandatoryEntity(JsonNode jsonNode, Class<T> clazz, String ... path) {
        JsonPointer jsonPointer = this.computeIdPointer(path);
        long primaryKey = this.getPrimaryKey(jsonNode, clazz, jsonPointer);
        Identified entity = (Identified)this.entityManager.find(clazz, (Object)primaryKey);
        if (entity == null) {
            String message = "The json object with path : %s is not valid. No object %s found with id %d".formatted(jsonPointer, clazz.getName(), primaryKey);
            throw new IllegalArgumentException(message);
        }
        return (T)entity;
    }

    private <T extends Identified> long getPrimaryKey(JsonNode jsonNode, Class<T> clazz, JsonPointer jsonPointer) {
        JsonNode targetNode = jsonNode.at(jsonPointer);
        if (targetNode == null) {
            String message = "The json object with path : %s is null. Must provide a %s object with an id attribute inside.".formatted(jsonPointer, clazz.getName());
            throw new IllegalArgumentException(message);
        }
        if (!targetNode.canConvertToLong()) {
            String message = "The json object with path : %s is not a number. Must provide a %s object with a valid id attribute inside.".formatted(jsonPointer, clazz.getName());
            throw new IllegalArgumentException(message);
        }
        return targetNode.asLong();
    }

    public JsonPointer computeIdPointer(String[] path) {
        if (path == null || path.length == 0) {
            return JsonPointer.compile((String)"/id");
        }
        String pointer = StringUtils.join((Object[])path, (String)"/");
        if (!"id".equals(path[path.length - 1])) {
            pointer = StringUtils.appendIfMissing((String)pointer, (CharSequence)"/id", (CharSequence[])new CharSequence[0]);
        }
        pointer = StringUtils.prependIfMissing((String)pointer, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return JsonPointer.compile((String)pointer);
    }

    public JsonPointer computePointer(String[] path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Programmatic error, you should provide a not empty path");
        }
        JsonPointer jsonPointer = JsonPointer.compile((String)StringUtils.prependIfMissing((String)path[0], (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        int i = 1;
        while (i < path.length) {
            JsonPointer tail = JsonPointer.compile((String)StringUtils.prependIfMissing((String)path[0], (CharSequence)"/", (CharSequence[])new CharSequence[0]));
            jsonPointer = jsonPointer.append(tail);
            ++i;
        }
        return jsonPointer;
    }
}

