/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.SprintGroupDto;
import org.squashtest.tm.plugin.rest.service.RestSprintGroupService;
import org.squashtest.tm.plugin.rest.validators.SprintGroupPatchValidator;
import org.squashtest.tm.plugin.rest.validators.SprintGroupPostValidator;

@RestApiController(value=SprintGroup.class)
@UseDefaultRestApiConfiguration
public class RestSprintGroupController
extends BaseRestController {
    @Inject
    private RestSprintGroupService sprintGroupService;
    @Inject
    private SprintGroupPostValidator sprintGroupPostValidator;
    @Inject
    private SprintGroupPatchValidator sprintGroupPatchValidator;

    @GetMapping(value={"/sprint-groups/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name]")
    public ResponseEntity<EntityModel<SprintGroup>> findSprintGroup(@PathVariable(value="id") long id) {
        SprintGroup sprintGroup = this.sprintGroupService.getOne(id);
        EntityModel entityModel = this.toEntityModel((Identified)sprintGroup);
        entityModel.add(this.linkService.createLinkTo((Identified)sprintGroup.getProject()));
        return ResponseEntity.ok((Object)entityModel);
    }

    @GetMapping(value={"/sprint-groups"})
    @ResponseBody
    @DynamicFilterExpression(value="id, name, reference")
    public ResponseEntity<PagedModel<EntityModel<SprintGroup>>> findAllReadableSprintGroups(Pageable pageable) {
        Page<SprintGroup> sprintGroups = this.sprintGroupService.findAllReadable(pageable);
        PagedModel res = this.toPagedModel(sprintGroups);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/sprint-groups/{id}/content"})
    @ResponseBody
    @DynamicFilterExpression(value="name, reference")
    public ResponseEntity<PagedModel<EntityModel<CampaignLibraryNode>>> findSprintGroupContent(@PathVariable(value="id") long sprintGroupId, @SortDefault(sort={"nodes.id"}, direction=Sort.Direction.ASC) Pageable pageable, ContentInclusion include) {
        Page<CampaignLibraryNode> content = include.equals((Object)ContentInclusion.NESTED) ? this.sprintGroupService.findSprintGroupAllContent(sprintGroupId, pageable) : this.sprintGroupService.findSprintGroupRootContent(sprintGroupId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(content, "content");
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/sprint-groups"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name]")
    public ResponseEntity<EntityModel<SprintGroup>> createSprintGroup(@RequestBody SprintGroupDto sprintGroupDto) throws BindException {
        this.validatePostSprintGroup(sprintGroupDto);
        SprintGroup sprintGroup = this.sprintGroupService.createSprintGroup(sprintGroupDto);
        EntityModel res = this.toEntityModel((Identified)sprintGroup);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    private void validatePostSprintGroup(SprintGroupDto sprintGroupDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)sprintGroupDto, "post-sprint-group");
        this.sprintGroupPostValidator.validate(sprintGroupDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(sprintGroupDto, errors, "post-sprint-group");
    }

    @PatchMapping(value={"/sprint-groups/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<SprintGroup>> patchSprintGroup(@RequestBody SprintGroupDto sprintGroupDto, @PathVariable(value="id") long id) throws BindException {
        sprintGroupDto.setId(id);
        this.validatePatchSprintGroup(sprintGroupDto);
        SprintGroup sprintGroup = this.sprintGroupService.patchSprintGroup(sprintGroupDto, id);
        EntityModel res = this.toEntityModel((Identified)sprintGroup);
        return ResponseEntity.ok((Object)res);
    }

    private void validatePatchSprintGroup(SprintGroupDto sprintGroupDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)sprintGroupDto, "patch-sprint-group");
        this.sprintGroupPatchValidator.validate(sprintGroupDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(sprintGroupDto, errors, "patch-sprint-group");
    }

    @DeleteMapping(value={"/sprint-groups/{ids}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteSprintGroups(@PathVariable(value="ids") List<Long> ids) {
        this.sprintGroupService.deleteSprintGroupsByIds(ids);
        return ResponseEntity.noContent().build();
    }
}

