/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.DisableSort;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.SprintDto;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestSprintService;
import org.squashtest.tm.plugin.rest.validators.SprintPatchValidator;
import org.squashtest.tm.plugin.rest.validators.SprintPostValidator;

@RestApiController(value=Sprint.class)
@UseDefaultRestApiConfiguration
public class RestSprintController
extends BaseRestController {
    public static final String TEST_PLAN = "test-plan";
    private static final String CREATE_SPRINT_REQ_VERSION = "create-sprint-req-version";
    @Inject
    private RestSprintService sprintService;
    @Inject
    private SprintPostValidator sprintPostValidator;
    @Inject
    private SprintPatchValidator sprintPatchValidator;
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/sprints/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name]")
    public ResponseEntity<EntityModel<Sprint>> findSprint(@PathVariable(value="id") long id) {
        Sprint sprint = this.sprintService.getOne(id);
        EntityModel entityModel = this.toEntityModel((Identified)sprint);
        entityModel.add(this.linkService.createLinkTo((Identified)sprint.getProject()));
        return ResponseEntity.ok((Object)entityModel);
    }

    @GetMapping(value={"/sprints"})
    @ResponseBody
    @DynamicFilterExpression(value="id,name,reference")
    public ResponseEntity<PagedModel<EntityModel<Sprint>>> findAllReadableSprints(Pageable pageable) {
        Page<Sprint> sprints = this.sprintService.findAllReadable(pageable);
        PagedModel res = this.toPagedModel(sprints);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/sprints/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by")
    public ResponseEntity<PagedModel<EntityModel<TestPlanItem>>> findSprintTestPlan(@PathVariable(value="id") long sprintId, @DisableSort Pageable pageable) {
        Page<TestPlanItem> testPlanItems = this.sprintService.findSprintTestPlan(sprintId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(testPlanItems, TEST_PLAN);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/sprints"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name]")
    public ResponseEntity<EntityModel<Sprint>> createSprint(@RequestBody SprintDto sprintDto) throws BindException {
        this.validatePostSprint(sprintDto);
        Sprint sprint = this.sprintService.createSprint(sprintDto);
        EntityModel res = this.toEntityModel((Identified)sprint);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    private void validatePostSprint(SprintDto sprintDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)sprintDto, "post-sprint");
        this.sprintPostValidator.validate(sprintDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(sprintDto, errors, "post-sprint");
    }

    @PatchMapping(value={"/sprints/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Sprint>> patchSprint(@RequestBody SprintDto sprintDto, @PathVariable(value="id") long id) throws BindException {
        sprintDto.setId(id);
        this.validatePatchSprint(sprintDto);
        Sprint sprint = this.sprintService.patchSprint(sprintDto, id);
        EntityModel res = this.toEntityModel((Identified)sprint);
        return ResponseEntity.ok((Object)res);
    }

    private void validatePatchSprint(SprintDto sprintDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)sprintDto, "patch-sprint");
        this.sprintPatchValidator.validate(sprintDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(sprintDto, errors, "patch-sprint");
    }

    @DeleteMapping(value={"/sprints/{ids}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteSprints(@PathVariable(value="ids") List<Long> ids) {
        this.sprintService.deleteSprintsByIds(ids);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/sprints/{sprintId}/requirements/{requirementIds}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name]")
    public ResponseEntity<EntityModel<Sprint>> createSprintReqVersion(@PathVariable(value="sprintId") long sprintId, @PathVariable(value="requirementIds") List<Long> requirementIds) throws BindException {
        this.sprintPostValidator.validateRequirements(sprintId, requirementIds, CREATE_SPRINT_REQ_VERSION);
        boolean hasCreatedSprintReqVersions = this.sprintService.linkRequirementsToSprint(sprintId, requirementIds);
        Sprint sprint = this.sprintService.getOne(sprintId);
        EntityModel res = this.toEntityModel((Identified)sprint);
        return hasCreatedSprintReqVersions ? ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res) : ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/sprints/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="executions[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findSprintIssues(@PathVariable(value="id") long id, Pageable pageable) {
        List<Long> executionIds = this.sprintService.getExecutionIdsBySprint(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(executionIds, pageable);
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }
}

