/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.DisableSort;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignDto;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.service.RestCampaignService;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.validators.CampaignPatchValidator;
import org.squashtest.tm.plugin.rest.validators.CampaignPostValidator;

@RestApiController(value=Campaign.class)
@UseDefaultRestApiConfiguration
public class RestCampaignController
extends BaseRestController {
    public static final String ITERATION_EMBEDDED_FILTER = "*, parent[name], -test_plan, test_suites[name],-path,-campaign";
    public static final String CTPI_EMBEDDED_FILTER = "*,referenced_test_case[name, reference], referenced_dataset[name], campaign[name,reference],-campaign";
    @Inject
    private RestCampaignService restCampaignService;
    @Inject
    private CampaignPostValidator campaignPostValidator;
    @Inject
    private CampaignPatchValidator campaignPatchValidator;
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/campaigns/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], iterations[name], test_plan[referenced_test_case[name]]")
    public ResponseEntity<EntityModel<Campaign>> findCampaign(@PathVariable(value="id") long id) {
        Campaign campaign = this.restCampaignService.getOne(id);
        EntityModel res = this.toEntityModel((Identified)campaign);
        res.add(this.linkService.createLinkTo((Identified)campaign.getProject()));
        res.add(this.createRelationTo("iterations"));
        res.add(this.createRelationTo("test-plan"));
        res.add(this.createRelationTo("attachments"));
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/campaigns"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedModel<EntityModel<Campaign>>> findCampaigns(@RequestParam(value="campaignName", required=false) String campaignName, @RequestParam(value="milestoneId", required=false) Long milestoneId, @RequestParam(value="milestoneLabel", required=false) String milestoneLabel, Pageable pageable) {
        if (milestoneId != null && milestoneLabel != null) {
            throw new IllegalArgumentException("Only one parameter between milestoneId or milestoneLabel should be provided");
        }
        Page<Campaign> campaigns = milestoneId != null || milestoneLabel != null || campaignName != null ? this.restCampaignService.findAllWithParameters(campaignName, milestoneId, milestoneLabel, pageable) : this.restCampaignService.findAllReadable(pageable);
        PagedModel res = this.toPagedModel(campaigns);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/campaigns"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Campaign>> createCampaign(@RequestBody CampaignDto campaignDto) throws BindException {
        this.validatePostCampaign(campaignDto);
        Campaign campaign = this.restCampaignService.createCampaign(campaignDto);
        EntityModel res = this.toEntityModel((Identified)campaign);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/campaigns/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Campaign>> patchCampaign(@RequestBody CampaignDto campaignDto, @PathVariable(value="id") long id) throws BindException {
        campaignDto.setId(id);
        this.validatePatchCampaign(campaignDto);
        Campaign campaign = this.restCampaignService.patchCampaign(campaignDto, id);
        EntityModel res = this.toEntityModel((Identified)campaign);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/campaigns/{ids}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteCampaign(@PathVariable(value="ids") List<Long> ids) {
        this.restCampaignService.deleteCampaignsByIds(ids);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/campaigns/{id}/iterations"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -test_plan, test_suites[name],-path,-campaign")
    public ResponseEntity<PagedModel<EntityModel<Iteration>>> findAllCampaignIterations(@PathVariable(value="id") long id, Pageable pageable) {
        Page<Iteration> tcs = this.restCampaignService.findIterations(id, pageable);
        PagedModel res = this.toPagedModel(tcs);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/campaigns/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*,referenced_test_case[name, reference], referenced_dataset[name], campaign[name,reference],-campaign")
    public ResponseEntity<PagedModel<EntityModel<CampaignTestPlanItem>>> findAllCampaignTestPlan(@PathVariable(value="id") long id, @DisableSort Pageable pageable) {
        Page<CampaignTestPlanItem> tcs = this.restCampaignService.findTestPlan(id, pageable);
        PagedModel res = this.toPagedModel(tcs);
        return ResponseEntity.ok((Object)res);
    }

    private void validatePostCampaign(CampaignDto dto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)dto, "post-campaign");
        this.campaignPostValidator.validate(dto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(dto, errors, "post-campaign");
    }

    private void validatePatchCampaign(CampaignDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-campaign");
        this.campaignPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-campaign");
    }

    @GetMapping(value={"/campaigns/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="executions[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findCampaignsIssues(@PathVariable(value="id") long id, Pageable pageable) {
        List<Long> executionIds = this.restCampaignService.getExecutionIdsByCampaign(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(executionIds, pageable);
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }
}

