/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.persistence.EntityNotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.plugin.rest.core.web.IRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.AttachmentRestDto;
import org.squashtest.tm.plugin.rest.jackson.model.SuiteCompletionRequestDto;
import org.squashtest.tm.plugin.rest.service.RestOrchestratorFeaturesAvailabilityService;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.testautomation.OrchestratorAutomatedExecutionLifecycleService;
import org.squashtest.tm.service.testautomation.model.Attachment;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;
import org.squashtest.tm.service.testautomation.model.ExecutionsLifecycleInfo;
import org.squashtest.tm.service.testautomation.resultpublisher.AutomatedSuiteCompletionService;
import org.squashtest.tm.service.testautomation.resultpublisher.AutomatedSuitePublisherService;
import org.squashtest.tm.service.testautomation.resultpublisher.ExecutionService;
import org.squashtest.tm.service.testautomation.resultpublisher.ResultPublicationService;

@UseDefaultRestApiConfiguration
@RestApiController
public class RestAutomatedSuiteUpdateController
implements IRestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAutomatedSuiteUpdateController.class);
    private final ResultPublicationService publicationService;
    private final AutomatedSuitePublisherService automatedSuitePublisherService;
    private final ExecutionService executionService;
    private final RestOrchestratorFeaturesAvailabilityService orchestratorFeaturesAvailabilityService;
    private final AutomatedSuiteCompletionService automatedSuiteCompletionService;
    private final OrchestratorAutomatedExecutionLifecycleService orchestratorAutomatedExecutionLifecycleService;

    public RestAutomatedSuiteUpdateController(ResultPublicationService publicationService, AutomatedSuitePublisherService automatedSuitePublisherService, ExecutionService executionService, RestOrchestratorFeaturesAvailabilityService orchestratorFeaturesAvailabilityService, AutomatedSuiteCompletionService automatedSuiteCompletionService, OrchestratorAutomatedExecutionLifecycleService orchestratorAutomatedExecutionLifecycleService) {
        this.publicationService = publicationService;
        this.automatedSuitePublisherService = automatedSuitePublisherService;
        this.executionService = executionService;
        this.orchestratorFeaturesAvailabilityService = orchestratorFeaturesAvailabilityService;
        this.automatedSuiteCompletionService = automatedSuiteCompletionService;
        this.orchestratorAutomatedExecutionLifecycleService = orchestratorAutomatedExecutionLifecycleService;
    }

    @ResponseBody
    @PostMapping(value={"resultpublisher/{suiteId}/automated-executions/{testId}/test-status"})
    public synchronized void updateITPIState(@PathVariable String suiteId, @PathVariable long testId, @RequestBody AutomatedExecutionState stateChange) {
        this.orchestratorFeaturesAvailabilityService.denyOrchestratorFeaturesForCloudPremiumOrWithoutDefinedTestAutomationServer();
        this.executionService.addItpiLabelAndIdToAttachmentName(testId, stateChange);
        this.publicationService.publishResult(suiteId, testId, stateChange);
    }

    @ResponseBody
    @PostMapping(value={"resultpublisher/{suiteId}/automated-executions/attachments"})
    public synchronized ResponseEntity<AttachmentRestDto> attachToAutomatedSuite(@PathVariable String suiteId, @RequestBody Attachment allureAttachment) {
        this.orchestratorFeaturesAvailabilityService.denyOrchestratorFeaturesForCloudPremiumOrWithoutDefinedTestAutomationServer();
        AttachmentDto dto = this.automatedSuitePublisherService.attachReportToAutomatedSuite(suiteId, allureAttachment);
        AttachmentRestDto attachmentRestDto = new AttachmentRestDto(dto.getId(), dto.getName(), dto.getSize(), dto.getAddedOn());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)attachmentRestDto);
    }

    @ResponseBody
    @PutMapping(value={"attachments/{id}"})
    public synchronized ResponseEntity<AttachmentRestDto> updateAutomatedSuiteAttachmentContent(@PathVariable Long id, @RequestBody Attachment allureAttachment) {
        try {
            AttachmentDto dto = this.automatedSuitePublisherService.updateAttachmentContent(allureAttachment, id);
            AttachmentRestDto attachmentRestDto = new AttachmentRestDto(dto.getId(), dto.getName(), dto.getSize(), dto.getAddedOn());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)attachmentRestDto);
        }
        catch (EntityNotFoundException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
    }

    @ResponseBody
    @PutMapping(value={"resultpublisher/{suiteId}/automated-executions/suite-status"}, consumes={"application/json"})
    public void updateAutomatedSuiteStatus(@PathVariable String suiteId, HttpServletRequest request) throws IOException {
        this.orchestratorFeaturesAvailabilityService.denyOrchestratorFeaturesForCloudPremiumOrWithoutDefinedTestAutomationServer();
        String status = this.extractBody(request);
        this.automatedSuitePublisherService.updateAutomatedSuiteExecStatus(suiteId, status);
    }

    private String extractBody(HttpServletRequest request) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @ResponseBody
    @PostMapping(value={"resultpublisher/{suiteId}/executions-lifecycle"})
    public ResponseEntity<Void> updateExecutionsLifecycle(@PathVariable String suiteId, @RequestBody ExecutionsLifecycleInfo lifecycleInfo) {
        this.orchestratorFeaturesAvailabilityService.denyOrchestratorFeaturesForCloudPremiumOrWithoutDefinedTestAutomationServer();
        this.orchestratorAutomatedExecutionLifecycleService.updateExecutionsLifecycle(suiteId, lifecycleInfo);
        return ResponseEntity.noContent().build();
    }

    @ResponseBody
    @PostMapping(value={"resultpublisher/{suiteId}/suite-completion"}, consumes={"application/json"})
    public ResponseEntity<Void> completeSuite(@PathVariable String suiteId, @RequestBody(required=false) SuiteCompletionRequestDto payload) {
        this.orchestratorFeaturesAvailabilityService.denyOrchestratorFeaturesForCloudPremiumOrWithoutDefinedTestAutomationServer();
        List workflowUuids = payload == null || payload.workflowUuids() == null ? List.of() : payload.workflowUuids().stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).toList();
        LOGGER.info("Suite completion requested for suite: {} with {} workflowUuids", (Object)suiteId, (Object)workflowUuids.size());
        this.automatedSuiteCompletionService.performCompletionActions(suiteId, workflowUuids);
        return ResponseEntity.noContent().build();
    }
}

