--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-dm8vx5ae (100.64.7.5)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-2.1.0.xml
--  Ran at: 16/02/2026 15:28
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.31.1
--  *********************************************************************

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-2.1.0.xml', NOW(), 1, '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0::dclaerhout
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '2.1.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0', 'dclaerhout', '../tm/tm.changelog-2.1.0.xml', NOW(), 2, '9:583e259b782f2a4d600de1026e44f558', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0-add-remote-req-perimeter-status::dclaerhout
ALTER TABLE REQUIREMENT_SYNC_EXTENDER ADD REMOTE_REQ_PERIMETER_STATUS VARCHAR(30) DEFAULT 'UNKNOWN' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-add-remote-req-perimeter-status', 'dclaerhout', '../tm/tm.changelog-2.1.0.xml', NOW(), 3, '9:08e66d183c4e8f1919b8767eb493e0f4', 'addColumn tableName=REQUIREMENT_SYNC_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0-SQUASH-4052-delete-owner-in-report-and-chart::jprioux
--  Remove the USER_ID columns and associated foreign keys
ALTER TABLE CHART_DEFINITION DROP FOREIGN KEY fk_chart_owner;

ALTER TABLE CHART_DEFINITION DROP COLUMN USER_ID;

ALTER TABLE REPORT_DEFINITION DROP FOREIGN KEY fk_report_owner;

ALTER TABLE REPORT_DEFINITION DROP COLUMN USER_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-SQUASH-4052-delete-owner-in-report-and-chart', 'jprioux', '../tm/tm.changelog-2.1.0.xml', NOW(), 4, '9:197c7c9475487eaeaedfb0af937865fe', 'dropForeignKeyConstraint baseTableName=CHART_DEFINITION, constraintName=fk_chart_owner; dropColumn columnName=USER_ID, tableName=CHART_DEFINITION; dropForeignKeyConstraint baseTableName=REPORT_DEFINITION, constraintName=fk_report_owner; dropColumn...', 'Remove the USER_ID columns and associated foreign keys', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset ../tm/tm.changelog-2.1.0.xml::tm-2.1.0-add-template-configurable-plugin-binding::pckerneis
--  Add the template_configurable_plugin_binding table.
CREATE TABLE TEMPLATE_CONFIGURABLE_PLUGIN_BINDING (BINDING_ID BIGINT AUTO_INCREMENT NOT NULL, PROJECT_TEMPLATE_ID BIGINT NOT NULL, PROJECT_ID BIGINT NOT NULL, PLUGIN_ID VARCHAR(50) NOT NULL, CONSTRAINT PK_TEMPLATE_CONFIGURABLE_PLUGIN_BINDING PRIMARY KEY (BINDING_ID), CONSTRAINT fk_template_configurable_plugin_binding__project__project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_template_configurable_plugin_binding__template__project_id FOREIGN KEY (PROJECT_TEMPLATE_ID) REFERENCES PROJECT(PROJECT_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-2.1.0-add-template-configurable-plugin-binding', 'pckerneis', '../tm/tm.changelog-2.1.0.xml', NOW(), 5, '9:68c27f8f54df06718634c032ab926065', 'createTable tableName=TEMPLATE_CONFIGURABLE_PLUGIN_BINDING', 'Add the template_configurable_plugin_binding table.', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

