/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define([ "jquery", "backbone"], function($, Backbone) {


	var wizardRouter = Backbone.Router.extend({

	    initialize : function(options) {

			this.wizardView = options.wizardView;
		},

		routes : {
			"" : "actionChoiceStep",
			"actionChoiceStep": "actionChoiceStep",
			"sourceIterationStep": "sourceIterationStep",
			"simpleCriteriaStep": "simpleCriteriaStep",
			"advancedCriteriaStep": "advancedCriteriaStep",
			"previewStep": "previewStep",
			"targetIterationStep": "targetIterationStep"
		},

		actionChoiceStep: function() {

			this.wizardView.showActionChoiceStep(this);
		},

		sourceIterationStep : function() {

    	this.wizardView.showSourceIterationStep(this);
        },

        simpleCriteriaStep : function() {

            this.wizardView.showSimpleCriteriaStep(this);
        },

        advancedCriteriaStep : function() {

            this.wizardView.showAdvancedCriteriaStep(this);
        },

        previewStep : function() {

            this.wizardView.showPreviewStep(this);
        },

        targetIterationStep : function() {

            this.wizardView.showTargetIterationStep(this);
        }

	});

	return wizardRouter;

});


