/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.wizard.campaignassistant.internal.service.dto;

import java.util.stream.Collectors;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.testcase.TestCase;

public class IterationTestPlanItemDto {
    private Long id;
    private String project;
    private String reference;
    private String name;
    private String importance;
    private String dataset;
    private String suites;
    private String user;
    private Long testCaseId;

    public IterationTestPlanItemDto(TestPlanItem srcItpi, boolean copySuites, boolean copyUser) {
        this.id = srcItpi.getId();
        TestCase referencedTestCase = srcItpi.getReferencedTestCase();
        if (referencedTestCase != null) {
            this.project = referencedTestCase.getProject().getName();
            this.reference = referencedTestCase.getReference();
            this.name = referencedTestCase.getName();
            this.importance = referencedTestCase.getImportance().toString();
            this.testCaseId = referencedTestCase.getId();
        }
        if (srcItpi.getReferencedDataset() != null) {
            this.dataset = srcItpi.getReferencedDataset().getName();
        }
        if (copySuites) {
            this.suites = srcItpi.getTestSuites().stream().map(TestSuite::getName).collect(Collectors.joining(", "));
        }
        if (copyUser && srcItpi.getAssignee() != null) {
            this.user = srcItpi.getAssignee().getLogin();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImportance() {
        return this.importance;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getSuites() {
        return this.suites;
    }

    public void setSuites(String suites) {
        this.suites = suites;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(Long testCaseId) {
        this.testCaseId = testCaseId;
    }
}

