/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.squashtest.tm.domain.artificialintelligence.AiUseName;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerInvalidHandlebarsTemplateException;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.RequestPayloadGenerator;

@Service
public class HelpValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpValidator.class);
    private static final String AI_USE = "aiUse";
    private static final String INVALID_VALUE = "Invalid value";

    public void validateAttributes(String attribute, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)attribute, (String)"required", (String)"This attribute can't be empty");
    }

    public void validateUrl(String strUrl, Errors errors) {
        try {
            new URL(strUrl);
        }
        catch (MalformedURLException malformedURLException) {
            errors.rejectValue("url", INVALID_VALUE, "Malformed Url.");
        }
    }

    public void validateAiUse(BindingResult validation, String aiUse) {
        if (StringUtils.isBlank((CharSequence)aiUse)) {
            this.validateAttributes(AI_USE, (Errors)validation);
        } else {
            boolean isValidAiUse = Arrays.stream(AiUseName.values()).anyMatch(enumValue -> enumValue.name().equals(aiUse));
            if (!isValidAiUse) {
                validation.rejectValue(AI_USE, INVALID_VALUE, "The aiUse %s is not a valid value".formatted(aiUse));
            }
        }
    }

    public void validateHandlebarsTemplate(Errors errors, String fieldName, String template) {
        try {
            RequestPayloadGenerator.generate((String)template, (String)fieldName, new ArrayList(), (String)"");
        }
        catch (AiServerInvalidHandlebarsTemplateException e) {
            String message = "The %s is not a valid Handlebars template.".formatted(fieldName);
            LOGGER.error(message, (Throwable)e);
            errors.rejectValue(fieldName, INVALID_VALUE, message);
        }
    }
}

