/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.jackson.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiServerOptionsDto;
import org.squashtest.tm.plugin.rest.core.jackson.RestDtoName;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.CustomAiServerConfiguration;

@RestDtoName(value="ai-server")
public class AiServerDto {
    private Long id;
    private String name;
    private String url;
    private String description;
    @JsonProperty(value="model_name")
    private String modelName;
    private String provider;
    private AiServerOptionsDto options;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public AiServerOptionsDto getOptions() {
        return this.options;
    }

    public void setOptions(AiServerOptionsDto options) {
        this.options = options;
    }

    public AiServer toAiServer() {
        AiServer server = new AiServer();
        server.setName(this.name);
        if (AiProvider.GOOGLE_VERTEX_AI.name().equals(this.provider) && StringUtils.isBlank((CharSequence)this.url)) {
            server.setUrl("https://unused");
        } else {
            server.setUrl(this.url);
        }
        server.setDescription(this.description);
        server.setProvider(AiProvider.valueOf((String)this.provider));
        server.setModelName(this.modelName);
        this.handleOptions(server);
        return server;
    }

    private void handleOptions(AiServer server) {
        if (Objects.nonNull(this.options)) {
            if (this.isCustomAiServer()) {
                server.setOptions(this.options.toCustomAiServerConfigurationAsString(new CustomAiServerConfiguration()));
            } else {
                server.setOptions(this.options.toAiServerConfigurationAsString(new AiServerConfiguration()));
            }
        }
    }

    private boolean isCustomAiServer() {
        return AiProvider.CUSTOM.name().equals(this.provider);
    }
}

