/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.scm.git.internal.scheduling;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.plugin.scm.git.internal.scheduling.SingleScheduledTaskExecutorService;

@Component
public class ScheduledTaskManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledTaskManagerService.class);
    private static final Map<Long, SingleScheduledTaskExecutorService> repositoriesTimers = new ConcurrentHashMap<Long, SingleScheduledTaskExecutorService>();

    private SingleScheduledTaskExecutorService getExecutor(Long repositoryId) {
        return repositoriesTimers.computeIfAbsent(repositoryId, id -> new SingleScheduledTaskExecutorService());
    }

    public Future scheduleOneTask(Long scmRepositoryId, Callable<?> command, int delay) {
        LOGGER.debug("Scheduling command of type {} to the Scheduler of ScmRepository of id {}.", command.getClass(), (Object)scmRepositoryId);
        SingleScheduledTaskExecutorService executor = this.getExecutor(scmRepositoryId);
        return executor.schedule(command, delay, TimeUnit.SECONDS);
    }

    public void cancelScheduledTask(Long scmRepositoryId) {
        LOGGER.trace("Cancelling the single scheduled task in Scheduler of ScmRepository of id {}", (Object)scmRepositoryId);
        SingleScheduledTaskExecutorService executor = this.getExecutor(scmRepositoryId);
        executor.cancelScheduledTask();
        LOGGER.debug("Successfully cancelled the current scheduled task in Scheduler of ScmRepository of id {}", (Object)scmRepositoryId);
    }
}

