/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.MethodParameter;
import org.springframework.validation.AbstractBindingResult;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.library.GenericLibraryNode;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.plugin.rest.core.exception.ProgrammingError;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationDynamicFilter;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationFilterExpression;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.core.jackson.EntityManagerWrapper;
import org.squashtest.tm.plugin.rest.core.jackson.WrappedDTO;
import org.squashtest.tm.plugin.rest.core.service.NodeHierarchyHelpService;

public class DeserializationConfigHelper {
    private static final Pattern PLACEHOLDER_MATCHER = Pattern.compile("\\{[^\\\\}]+\\}");
    private static final String MATCH_IDS = "(\\\\d+)";
    private EntityManagerWrapper em;
    private NodeHierarchyHelpService hierarchyService;

    public DeserializationConfigHelper(EntityManagerWrapper em, NodeHierarchyHelpService hierarchyService) {
        this.em = em;
        this.hierarchyService = hierarchyService;
    }

    public DeserializationHints createHints(HttpServletRequest request, MethodParameter param, String modelName) {
        DeserializationHints hints = this.createHints(request, param);
        hints.setBindingResult((AbstractBindingResult)new BeanPropertyBindingResult(null, modelName));
        return hints;
    }

    public DeserializationHints createHints(HttpServletRequest request, MethodParameter param) {
        DeserializationHints.Mode mode = this.extractMode(request);
        DeserializationDynamicFilter filter = this.extractFilter(param);
        if (Objects.requireNonNull(mode) != DeserializationHints.Mode.DESERIALIZE_UPDATE) {
            throw new ProgrammingError("Eh, that case was not implemented yet !");
        }
        Identified target = this.getTarget(request, param);
        GenericProject project = this.getProjectFromEntity(target);
        Identified parent = this.getParentFromEntity(target);
        DeserializationHints hints = new DeserializationHints();
        hints.setMode(mode);
        hints.setFilter(filter);
        hints.setTargetEntity(target);
        hints.setProject(project);
        hints.setParent(parent);
        return hints;
    }

    private DeserializationHints.Mode extractMode(HttpServletRequest request) {
        DeserializationHints.Mode mode = null;
        switch (request.getMethod()) {
            case "POST": {
                mode = DeserializationHints.Mode.DESERIALIZE_CREATE;
                break;
            }
            case "PATCH": {
                mode = DeserializationHints.Mode.DESERIALIZE_UPDATE;
                break;
            }
            default: {
                throw new RuntimeException("attempted processing http method '" + request.getMethod() + "', yet only POST or PATCH are supported");
            }
        }
        return mode;
    }

    private DeserializationDynamicFilter extractFilter(MethodParameter param) {
        String strExpr = "*";
        DeserializationFilterExpression expr = (DeserializationFilterExpression)param.getMethodAnnotation(DeserializationFilterExpression.class);
        if (expr != null) {
            strExpr = expr.value();
        }
        return new DeserializationDynamicFilter(strExpr);
    }

    private Identified getTarget(HttpServletRequest request, MethodParameter param) {
        Class<?> targetClass = this.extractTargetType(param);
        Long targetId = this.extractIdFromUrl(request, param);
        return (Identified)this.em.find(targetClass, targetId);
    }

    private Class<?> extractTargetType(Class<?> rawtype) {
        if (WrappedDTO.class.isAssignableFrom(rawtype)) {
            Type type = rawtype;
            do {
                if (type instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    type = ((Class)parameterizedType.getRawType()).getGenericSuperclass();
                    continue;
                }
                type = type.getGenericSuperclass();
            } while (!(type instanceof ParameterizedType) && ((ParameterizedType)type).getRawType() != WrappedDTO.class);
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return rawtype;
    }

    private Class<?> extractTargetType(MethodParameter param) {
        Class rawtype = param.getParameterType();
        return this.extractTargetType(rawtype);
    }

    private Long extractIdFromUrl(HttpServletRequest request, MethodParameter param) {
        RequestMapping annot = (RequestMapping)param.getMethodAnnotation(RequestMapping.class);
        Matcher matcher = this.toPattern(annot).matcher(request.getRequestURI());
        if (matcher.find()) {
            return Long.valueOf(matcher.group(1));
        }
        return null;
    }

    private GenericProject getProjectFromEntity(Identified entity) {
        Class<?> targetClass = entity.getClass();
        if (BoundEntity.class.isAssignableFrom(targetClass)) {
            return ((BoundEntity)entity).getProject();
        }
        if (GenericLibraryNode.class.isAssignableFrom(targetClass)) {
            return ((GenericLibraryNode)entity).getProject();
        }
        return null;
    }

    private Identified getParentFromEntity(Identified entity) {
        Class<?> targetClass = entity.getClass();
        NodeContainer<? extends LibraryNode> parent = null;
        if (TestCaseLibraryNode.class.isAssignableFrom(targetClass)) {
            parent = this.hierarchyService.findParentFor((TestCaseLibraryNode)entity);
        } else if (RequirementLibraryNode.class.isAssignableFrom(targetClass)) {
            parent = this.hierarchyService.findParentFor((RequirementLibraryNode)entity);
        } else if (RequirementVersion.class.isAssignableFrom(targetClass)) {
            parent = ((RequirementVersion)entity).getRequirement();
        } else if (CampaignLibraryNode.class.isAssignableFrom(targetClass)) {
            parent = this.hierarchyService.findParentFor((CampaignLibraryNode)entity);
        }
        return parent;
    }

    private Pattern toPattern(RequestMapping annot) {
        String orig = annot.value()[0];
        String replaced = PLACEHOLDER_MATCHER.matcher(orig).replaceAll(MATCH_IDS);
        return Pattern.compile(replaced + "$");
    }
}

