/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.client.internal;

import gitlabbt.org.glassfish.jersey.client.ClientRequest;
import gitlabbt.org.glassfish.jersey.client.innate.Expect100ContinueUsage;
import gitlabbt.org.glassfish.jersey.client.internal.ConnectorExtension;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;

class HttpUrlExpect100ContinueConnectorExtension
implements ConnectorExtension<HttpURLConnection, IOException> {
    private static final String EXCEPTION_MESSAGE = "Server rejected operation";

    HttpUrlExpect100ContinueConnectorExtension() {
    }

    @Override
    public void invoke(ClientRequest request, HttpURLConnection uc) {
        if (Expect100ContinueUsage.isAllowed(request, uc.getRequestMethod())) {
            uc.setRequestProperty("Expect", "100-Continue");
        }
    }

    @Override
    public void postConnectionProcessing(HttpURLConnection extensionParam) {
    }

    @Override
    public boolean handleException(ClientRequest request, HttpURLConnection extensionParam, IOException ex) {
        Boolean expectContinueActivated = request.resolveProperty("jersey.config.client.request.expect.100.continue.processing", Boolean.FALSE);
        return expectContinueActivated != false && ex instanceof ProtocolException && ex.getMessage().equals(EXCEPTION_MESSAGE);
    }
}

