/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.LabelEvent;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ResourceLabelEventsApi
extends AbstractApi {
    public ResourceLabelEventsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<LabelEvent> getIssueLabelEvents(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueLabelEvents(projectIdOrPath, issueIid, this.getDefaultPerPage()).all();
    }

    public Pager<LabelEvent> getIssueLabelEvents(Object projectIdOrPath, Long issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<LabelEvent>(this, LabelEvent.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "resource_label_events");
    }

    public Stream<LabelEvent> getIssueLabelEventsStream(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueLabelEvents(projectIdOrPath, issueIid, this.getDefaultPerPage()).stream();
    }

    public LabelEvent getIssueLabelEvent(Object projectIdOrPath, Long issueIid, Long resourceLabelEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "resource_label_events", resourceLabelEventId);
        return response.readEntity(LabelEvent.class);
    }

    public Optional<LabelEvent> getOptionalIssueLabelEvent(Object projectIdOrPath, Long issueIid, Long resourceLabelEventId) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getIssueLabelEvent(projectIdOrPath, issueIid, resourceLabelEventId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<LabelEvent> getEpicLabelEvents(Object projectIdOrPath, Long epicId) throws GitLabApiException {
        return this.getEpicLabelEvents(projectIdOrPath, epicId, this.getDefaultPerPage()).all();
    }

    public Pager<LabelEvent> getEpicLabelEvents(Object projectIdOrPath, Long epicId, int itemsPerPage) throws GitLabApiException {
        return new Pager<LabelEvent>(this, LabelEvent.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "epics", epicId, "resource_label_events");
    }

    public Stream<LabelEvent> getEpicLabelEventsStream(Object projectIdOrPath, Long epicId) throws GitLabApiException {
        return this.getEpicLabelEvents(projectIdOrPath, epicId, this.getDefaultPerPage()).stream();
    }

    public LabelEvent getEpicLabelEvent(Object projectIdOrPath, Long epicId, Long resourceLabelEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "epics", epicId, "resource_label_events", resourceLabelEventId);
        return response.readEntity(LabelEvent.class);
    }

    public Optional<LabelEvent> getOptionalEpicLabelEvent(Object projectIdOrPath, Long epicId, Long resourceLabelEventId) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getEpicLabelEvent(projectIdOrPath, epicId, resourceLabelEventId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<LabelEvent> getMergeRequestLabelEvents(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestLabelEvents(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public Pager<LabelEvent> getMergeRequestLabelEvents(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<LabelEvent>(this, LabelEvent.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "resource_label_events");
    }

    public Stream<LabelEvent> getMergeRequestLabelEventsStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestLabelEvents(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public LabelEvent getMergeRequestLabelEvent(Object projectIdOrPath, Long mergeRequestIid, Long resourceLabelEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "resource_label_events", resourceLabelEventId);
        return response.readEntity(LabelEvent.class);
    }

    public Optional<LabelEvent> getOptionalMergeRequestLabelEvent(Object projectIdOrPath, Long mergeRequestIid, Long resourceLabelEventId) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getMergeRequestLabelEvent(projectIdOrPath, mergeRequestIid, resourceLabelEventId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }
}

