/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.models.PersonalAccessToken;
import gitlabbt.org.gitlab4j.models.utils.ISO8601;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;

public class PersonalAccessTokenApi
extends AbstractApi {
    public PersonalAccessTokenApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public PersonalAccessToken rotatePersonalAccessToken() throws GitLabApiException {
        return this.rotatePersonalAccessToken(null);
    }

    public PersonalAccessToken rotatePersonalAccessToken(Date expiresAt) throws GitLabApiException {
        return this.rotatePersonalAccessToken("self", expiresAt);
    }

    public PersonalAccessToken rotatePersonalAccessToken(String id, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("expires_at", ISO8601.dateOnly(expiresAt));
        Response response = this.post(Response.Status.OK, (Form)formData, "personal_access_tokens", id, "rotate");
        return response.readEntity(PersonalAccessToken.class);
    }

    public List<PersonalAccessToken> getPersonalAccessTokens() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "personal_access_tokens");
        return response.readEntity(new GenericType<List<PersonalAccessToken>>(){});
    }

    public PersonalAccessToken getPersonalAccessToken() throws GitLabApiException {
        return this.getPersonalAccessToken("self");
    }

    public PersonalAccessToken getPersonalAccessToken(String id) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "personal_access_tokens", id);
        return response.readEntity(PersonalAccessToken.class);
    }

    public void revokePersonalAccessToken(Long tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "personal_access_tokens", tokenId);
    }
}

