/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.synchronisation.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testcase.GetKindTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.workflow.automjira.domain.GetFilenameTestCaseVisitor;
import org.squashtest.tm.plugin.workflow.automjira.domain.SynchronizedField;
import org.squashtest.tm.plugin.workflow.automjira.exception.CallbackUrlException;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.IssueProcessingHelperService;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.internal.library.PathService;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Service
@Transactional
public class IssueProcessingHelperServiceImpl
implements IssueProcessingHelperService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueProcessingHelperServiceImpl.class);
    private static final String TEST_CASE_PATH_ILLEGAL_PATTERN = "[^a-zA-Z0-9\\_\\-\\/]";
    @Value(value="${server.servlet.context-path}")
    private String servletContext;
    private final CallbackUrlProvider callbackUrlProvider;
    private final AutomatedTestDao automatedTestDao;
    private final ProjectDao projectDao;
    private final PathService pathService;
    private final PlatformTransactionManager transactionManager;
    private final InternationalizationHelper i18nHelper;

    public IssueProcessingHelperServiceImpl(CallbackUrlProvider callbackUrlProvider, AutomatedTestDao automatedTestDao, ProjectDao projectDao, PathService pathService, PlatformTransactionManager transactionManager, InternationalizationHelper i18nHelper) {
        this.callbackUrlProvider = callbackUrlProvider;
        this.automatedTestDao = automatedTestDao;
        this.projectDao = projectDao;
        this.pathService = pathService;
        this.transactionManager = transactionManager;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public String buildIssueSummary(TestCase testCase) {
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)testCase.getReference())) {
            builder.append(testCase.getReference()).append(" - ");
        }
        builder.append(testCase.getName());
        return builder.toString();
    }

    @Override
    public String buildIssueDescription(TestCase testCase) {
        String newLine = "\\\\";
        Locale defaultLocale = Locale.getDefault();
        String id = this.i18nHelper.internationalize("workflow.automation.jira.id.test.case", defaultLocale);
        String uuid = this.i18nHelper.internationalize("workflow.automation.jira.uuid.test.case", defaultLocale);
        String url = this.i18nHelper.internationalize("workflow.automation.jira.url.test.case", defaultLocale);
        String pathSharingServer = this.i18nHelper.internationalize("workflow.automation.jira.chemin.sharing.server", defaultLocale);
        String pathScriptTa = this.i18nHelper.internationalize("workflow.automation.jira.chemin.script.ta", defaultLocale);
        String priorite = this.i18nHelper.internationalize("workflow.automation.jira.priorite", defaultLocale);
        String responsable = this.i18nHelper.internationalize("workflow.automation.jira.responsable", defaultLocale);
        User transmidedBy = testCase.getAutomationRequest().getTransmittedBy();
        String user = transmidedBy.getLogin();
        StringBuilder builder = new StringBuilder();
        builder.append(id).append(" ").append(testCase.getId());
        builder.append(newLine);
        builder.append(uuid).append(" ").append(testCase.getUuid());
        builder.append(newLine);
        builder.append(url).append(" ").append(this.getUrlToTestCase(testCase) + " ");
        builder.append(newLine);
        GetKindTestCaseVisitor kindVisitor = new GetKindTestCaseVisitor();
        testCase.accept((TestCaseVisitor)kindVisitor);
        if (!TestCaseKind.STANDARD.equals((Object)kindVisitor.getKind())) {
            String pathCompletSharingServer = null;
            if (testCase.getProject().getScmRepository() != null) {
                pathCompletSharingServer = this.getFullPathSharingServer(testCase);
            }
            builder.append(pathSharingServer).append(" ").append(pathCompletSharingServer != null ? pathCompletSharingServer : "N/A");
            builder.append(newLine);
        } else {
            List automatedTests = this.automatedTestDao.findByTestCases(Collections.singletonList(testCase.getId()));
            AutomatedTest automatedTest = automatedTests.isEmpty() ? null : (AutomatedTest)automatedTests.get(0);
            String pathScript = this.getPathScriptTA(automatedTest);
            builder.append(pathScriptTa).append(" ").append(pathScript);
            builder.append(newLine);
        }
        builder.append(priorite).append(" ").append(this.getTestCasePriority(testCase));
        builder.append(newLine);
        builder.append(responsable).append(" ").append(user != null ? user : "N/A");
        builder.append(newLine);
        return builder.toString();
    }

    @Override
    public String getUrlToTestCase(TestCase testCase) {
        String url;
        String contextPath;
        try {
            contextPath = this.callbackUrlProvider.getCallbackUrl().toString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve callback url", (Throwable)e);
            throw new CallbackUrlException();
        }
        if (contextPath != null) {
            UriComponents uri = ServletUriComponentsBuilder.fromUriString((String)contextPath).path("/test-case-workspace/test-case/{tcId}").buildAndExpand(new Object[]{testCase.getId()});
            url = uri.toString();
        } else {
            UriComponents uri = ServletUriComponentsBuilder.fromPath((String)this.servletContext).path("/test-case-workspace/test-case/{tcId}").buildAndExpand(new Object[]{testCase.getId()});
            url = uri.toString();
        }
        return url;
    }

    @Override
    public String getValueSentForSync(TestCase testCase) throws JsonProcessingException {
        String urlTestCase = this.getUrlToTestCase(testCase);
        GetKindTestCaseVisitor kindVisitor = new GetKindTestCaseVisitor();
        testCase.accept((TestCaseVisitor)kindVisitor);
        String pathCompletSharingServer = TestCaseKind.STANDARD.equals((Object)kindVisitor.getKind()) ? "" : this.getFullPathSharingServer(testCase);
        String scriptTA = testCase.getAutomatedTest() != null ? testCase.getAutomatedTest().getFullLabel() : "N/A";
        String priorite = String.valueOf(testCase.getAutomationRequest().getAutomationPriority());
        SynchronizedField synchronizedField = new SynchronizedField(testCase.getReference(), testCase.getName(), urlTestCase, pathCompletSharingServer, scriptTA, priorite);
        return new ObjectMapper().writeValueAsString((Object)synchronizedField);
    }

    @Override
    public String getPathScriptTA(AutomatedTest automatedTest) {
        return automatedTest != null ? automatedTest.getFullLabel() : "N/A";
    }

    @Override
    public String getTestCasePriority(TestCase testCase) {
        return testCase.getAutomationRequest().getAutomationPriority() != null ? String.valueOf(testCase.getAutomationRequest().getAutomationPriority()) : "N/A";
    }

    @Override
    public String getFullPathSharingServer(TestCase testCase) {
        Project project = (Project)this.projectDao.getReferenceById((Object)testCase.getProject().getId());
        StringBuilder builder = new StringBuilder();
        String treeStructure = "";
        String fullPath = "";
        GetFilenameTestCaseVisitor filenameVisitor = new GetFilenameTestCaseVisitor();
        testCase.accept((TestCaseVisitor)filenameVisitor);
        String pathSharingServer = filenameVisitor.getFileName();
        ScmRepository scmRepo = project.getScmRepository();
        if (scmRepo != null) {
            if (testCase.getProject().isUseTreeStructureInScmRepo()) {
                treeStructure = this.getFoldersPath(testCase);
            }
            fullPath = builder.append(scmRepo.getScmServer().getUrl()).append("/").append(scmRepo.getName()).append("/blob/").append(scmRepo.getWorkingBranch()).append("/").append(scmRepo.getWorkingFolderPath()).append("/").append(treeStructure).append(pathSharingServer).append(" ").toString();
        }
        return fullPath;
    }

    @Override
    public TransactionStatus createTransaction() {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        return this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
    }

    private String getFoldersPath(TestCase testCase) {
        if (!testCase.getProject().isUseTreeStructureInScmRepo()) {
            return "";
        }
        String testCaseFoldersPath = this.pathService.buildTestCaseFoldersPath(testCase.getId().longValue());
        if (testCaseFoldersPath != null) {
            return this.normalizeFilePath(testCaseFoldersPath) + "/";
        }
        return "";
    }

    private String normalizeFilePath(String path) {
        return StringUtils.stripAccents((String)path).replaceAll(TEST_CASE_PATH_ILLEGAL_PATTERN, "_");
    }
}

