/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.sync.PathValidationDomainException;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModel;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.CredentialStatusDto;
import org.squashtest.tm.plugin.jirasync.domain.FieldLink;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.exception.LocalePluginValidationException;
import org.squashtest.tm.plugin.jirasync.exception.NoneSelectedJiraServerException;
import org.squashtest.tm.plugin.jirasync.helpers.ValueMappingsYamlDeserializer;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteRequirementFinder;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteRequirementFinderFactory;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.remotesynchronisation.RemoteSynchronisationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Service(value="squash.tm.plugin.jirasync.configurationService")
@Transactional
public class ConfigurationService {
    private static final String UPDATE_SYNC = "updateSync";
    private static final String CREATE_SPRINT_SYNC = "createSprintSync";
    private static final String SPRINT_SYNC_PATH_FIELD = "sprintSynchronisationPath";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationService.class);
    private static final String MANAGE_SYNC_OR_ROLE_ADMIN = "hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')";
    private final PluginRequirementDao dao;
    private final InternationalizationHelper inHelper;
    private final ClientProvider clientProvider;
    private final ValueMappingsYamlDeserializer valueMappingsYamlDeserializer;
    private final RemoteSynchronisationService remoteSynchronisationService;
    private final RemoteSynchronisationDao remoteSynchronisationDao;
    private final RequirementSyncExtenderDao requirementSyncExtenderDao;
    private final CustomGenericProjectManager customGenericProjectManager;
    private final PermissionEvaluationService permissionEvaluationService;
    private final RemoteRequirementFinderFactory remoteRequirementFinderFactory;
    @PersistenceContext
    private EntityManager entityManager;

    public ConfigurationService(PluginRequirementDao dao, InternationalizationHelper inHelper, ClientProvider clientProvider, ValueMappingsYamlDeserializer valueMappingsYamlDeserializer, RemoteSynchronisationService remoteSynchronisationService, RemoteSynchronisationDao remoteSynchronisationDao, RequirementSyncExtenderDao requirementSyncExtenderDao, CustomGenericProjectManager customGenericProjectManager, PermissionEvaluationService permissionEvaluationService, RemoteRequirementFinderFactory remoteRequirementFinderFactory) {
        this.dao = dao;
        this.inHelper = inHelper;
        this.clientProvider = clientProvider;
        this.valueMappingsYamlDeserializer = valueMappingsYamlDeserializer;
        this.remoteSynchronisationService = remoteSynchronisationService;
        this.remoteSynchronisationDao = remoteSynchronisationDao;
        this.requirementSyncExtenderDao = requirementSyncExtenderDao;
        this.customGenericProjectManager = customGenericProjectManager;
        this.permissionEvaluationService = permissionEvaluationService;
        this.remoteRequirementFinderFactory = remoteRequirementFinderFactory;
    }

    public Configuration getConfigurationForProject(RemoteSynchronisation remoteSynchronisation) {
        return this.dao.getConfigurationForProject(remoteSynchronisation.getProject().getId());
    }

    public Configuration getConfigurationForProject(Long projectId) {
        return this.dao.getConfigurationForProject(projectId);
    }

    public List<JiraRemoteSynchronisation> findRemoteSyncForProject(Long projectId, String pluginId) {
        return this.dao.findJiraRemoteSyncForProject(projectId, pluginId);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public JiraRemoteSynchronisation addJiraRemoteSynchronisation(long projectId, JiraRemoteSynchronisationModel model) {
        return this.doAddJiraRemoteSynchronisation(projectId, model, true);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public JiraRemoteSynchronisation addJiraRemoteSynchronisationWithoutValidation(long projectId, JiraRemoteSynchronisationModel model) {
        return this.doAddJiraRemoteSynchronisation(projectId, model, false);
    }

    private JiraRemoteSynchronisation doAddJiraRemoteSynchronisation(long projectId, JiraRemoteSynchronisationModel model, boolean shouldPerformValidation) {
        JiraRemoteSynchronisation sync = this.createJiraRemoteSynchronizationFromModel(projectId, model, shouldPerformValidation);
        this.checkMaxItems(model, sync);
        this.entityManager.persist((Object)sync.getRemoteSynchronisation());
        this.entityManager.flush();
        return sync;
    }

    private void checkMaxItems(JiraRemoteSynchronisationModel model, JiraRemoteSynchronisation sync) {
        if (model.isCheckMaxItems()) {
            this.checkIfMaxNumberOfIssuesInPerimeterExceeded(sync, false);
            if (model.isSprintSynchronisationEnable()) {
                this.checkIfMaxNumberOfIssuesInPerimeterExceeded(sync, true);
            }
        }
    }

    public void checkIfMaxNumberOfIssuesInPerimeterExceeded(JiraRemoteSynchronisation synchronisation, boolean isSprintSynchro) {
        RemoteRequirementFinder remoteRequirementFinder = this.remoteRequirementFinderFactory.create(synchronisation, this.clientProvider.getJiraClient(synchronisation));
        remoteRequirementFinder.checkIfMaxNumberOfIssuesInPerimeterExceeded(isSprintSynchro);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Project validateFormStepOne(long projectId, JiraRemoteSynchronisationModel model) {
        Project project = this.sanitizeAttributes(projectId, model);
        this.validateName(model.getName());
        this.validateJiraServer(model.getServerId());
        if (project == null) {
            this.throwLocalePluginValidationException("henix.jirasync.sync.dialog.add.addtoprojecttemplate");
        }
        this.remoteSynchronisationService.validatePathForRequirementSync(project.getName(), model.getSynchronisationPath());
        return project;
    }

    private Project sanitizeAttributes(long projectId, JiraRemoteSynchronisationModel model) {
        model.setName(model.getName().trim());
        model.cleanPaths();
        return (Project)this.entityManager.find(Project.class, (Object)projectId);
    }

    private JiraRemoteSynchronisation createJiraRemoteSynchronizationFromModel(Long projectId, JiraRemoteSynchronisationModel model, boolean shouldPerformValidation) {
        Project project;
        model.cleanPaths();
        if (shouldPerformValidation) {
            project = this.validateFormStepOne(projectId, model);
            if (model.isSprintSynchronisationEnable()) {
                this.remoteSynchronisationService.validatePathForSprintSync(project.getName(), model.getSprintSynchronisationPath());
            }
        } else {
            project = this.sanitizeAttributes(projectId, model);
        }
        return this.buildJiraRemoteSynchronizationFromModel(project, model);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public JiraRemoteSynchronisation simulateJiraRemoteSynchronisationFromModel(long projectId, JiraRemoteSynchronisationModel model) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)projectId);
        if (project == null) {
            this.throwLocalePluginValidationException("henix.jirasync.sync.dialog.add.addtoprojecttemplate");
        }
        return this.buildJiraRemoteSynchronizationFromModel(project, model);
    }

    private JiraRemoteSynchronisation buildJiraRemoteSynchronizationFromModel(Project project, JiraRemoteSynchronisationModel model) {
        User owner = null;
        if (model.getOwnerId() != null) {
            owner = (User)this.entityManager.find(User.class, (Object)model.getOwnerId());
        }
        JiraRemoteSynchronisation sync = new JiraRemoteSynchronisation(new RemoteSynchronisation());
        sync.setName(model.getName());
        sync.setSynchronisationPath(model.getSynchronisationPath());
        sync.setKind("squash.tm.plugin.jirasync");
        sync.setSelectType(model.getSelectType());
        if (StringUtils.isBlank((CharSequence)model.getSelectValue())) {
            this.throwLocalePluginValidationException("henix.jirasync.sync.dialog.add.emptyvalue");
        }
        sync.setSelectValue(model.getSelectValue());
        if (sync.isBoard()) {
            if (StringUtils.isNotBlank((CharSequence)model.getAdditionalJQL())) {
                sync.setAdditionalJQL(model.getAdditionalJQL());
            }
            this.addSprintInfoToSynchronisation(model, sync);
            sync.restrictedToActiveSprint(model.isRestrictedToActiveSprint());
        }
        sync.synchronisationEnable(model.isSynchronisationEnable());
        sync.setProject(project);
        sync.setOwner(owner);
        this.validateJiraServer(model.getServerId());
        BugTracker bugTracker = (BugTracker)this.entityManager.find(BugTracker.class, (Object)model.getServerId());
        sync.setServer(bugTracker);
        return sync;
    }

    private void addSprintInfoToSynchronisation(JiraRemoteSynchronisationModel model, JiraRemoteSynchronisation sync) {
        boolean isSprintSynchronisationEnabled = model.isSprintSynchronisationEnable();
        sync.sprintSynchronisationEnable(isSprintSynchronisationEnabled);
        if (isSprintSynchronisationEnabled) {
            if (StringUtils.isNotBlank((CharSequence)model.getSprintAdditionalJQL())) {
                sync.setSprintAdditionalJQL(model.getSprintAdditionalJQL());
            }
            if (StringUtils.isNotBlank((CharSequence)model.getSprintSynchronisationPath())) {
                sync.setSprintSynchronisationPath(model.getSprintSynchronisationPath());
            }
            sync.sprintRestrictedToActiveSprint(model.isSprintRestrictedToActiveSprint());
        }
    }

    private void validateJiraServer(Long serverId) {
        if (serverId == null || serverId.equals(0L)) {
            throw new NoneSelectedJiraServerException("serverId");
        }
    }

    public void validateName(String name) {
        List remoteSynchronisations;
        if (StringUtils.isBlank((CharSequence)name)) {
            this.throwLocalePluginValidationException("henix.jirasync.sync.dialog.add.emptyname");
        }
        if (!(remoteSynchronisations = this.remoteSynchronisationDao.findByNameAndKind(name, "squash.tm.plugin.jirasync")).isEmpty()) {
            throw new NameAlreadyInUseException("server", name, "name");
        }
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void addFieldMapping(long projectId, FieldMapping mapping) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        if (conf.hasFieldMapping(mapping)) {
            throw new PluginValidationException(this.inHelper.getMessage("henix.jirasync.mappings.add.invalid", new Object[]{mapping.getSquashField()}, "field mapping invalid", LocaleContextHolder.getLocale()));
        }
        conf.addFieldMapping(mapping);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeFieldMappings(long projectId, Collection<FieldMapping> mappings) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        for (FieldMapping map : mappings) {
            FieldMapping realItem = conf.getFieldMapping(map.getId());
            if (realItem == null || !realItem.isDeletable()) continue;
            conf.removeFieldMapping(realItem);
        }
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeFieldMappingsByIds(long projectId, Collection<String> ids) {
        ArrayList<FieldMapping> keys = new ArrayList<FieldMapping>(ids.size());
        for (String id : ids) {
            FieldMapping key = FieldMapping.byId(id);
            keys.add(key);
        }
        this.removeFieldMappings(projectId, keys);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateFieldMappingSquashField(long projectId, String mappingId, String newValue) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FieldMapping mapping = conf.getFieldMapping(mappingId);
        if (mapping == null) {
            return;
        }
        if (mapping.getSquashField().equals(newValue)) {
            return;
        }
        if (conf.hasFieldMapping(newValue)) {
            throw new PluginValidationException(this.inHelper.getMessage("henix.jirasync.mappings.add.invalid", new Object[]{newValue}, "field mapping invalid", LocaleContextHolder.getLocale()));
        }
        if (mapping.isLocked()) {
            throw new RuntimeException("attempted to modify a locked field mapping '" + mappingId + "' !");
        }
        mapping.setSquashField(newValue);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateFieldMappingJiraField(Long projectId, String mappingId, String newValue) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FieldMapping mapping = conf.getFieldMapping(mappingId);
        if (mapping.isLocked()) {
            throw new RuntimeException("attempted to modify a locked field mapping '" + mappingId + "' !");
        }
        mapping.setJiraField(newValue);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateValueMappings(Long projectId, String newValueMapping) {
        this.valueMappingsYamlDeserializer.deserialize(newValueMapping);
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setYamlFieldvalueMapping(newValueMapping);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateRequirementLinkJiraField(Long projectId, String linkId, String newValue) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FieldLink link = conf.getFieldLink(linkId);
        if (link != null && newValue.equals(link.getJiraField())) {
            return;
        }
        if (link != null) {
            link.setJiraField(newValue);
        }
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    public void deleteJiraRemoteSynchronisations(List<Long> syncIds) {
        this.checkPermissionOnSyncIds(syncIds);
        this.customGenericProjectManager.removeSynchronisationsByIds(syncIds);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void changeSync(long syncId, String bool) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        remoteSynchronisation.setSynchronisationEnable(Boolean.parseBoolean(bool));
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void changeSyncName(long syncId, String newName) {
        this.validateName(newName);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        remoteSynchronisation.setName(newName);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void changeSyncSelectValue(long syncId, String selectValue) {
        if (StringUtils.isBlank((CharSequence)selectValue)) {
            this.throwLocalePluginValidationException("henix.jirasync.sync.dialog.add.emptyvalue");
        }
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        remoteSynchronisation.setSelectValue(selectValue);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void changeSyncOwner(long syncId, Long ownerId) {
        RemoteSynchronisation remoteSynchronisationToUpdate = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        User newOwner = (User)this.entityManager.find(User.class, (Object)ownerId);
        remoteSynchronisationToUpdate.setOwner(newOwner);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void removeOwner(long syncId) {
        RemoteSynchronisation remoteSynchronisationToUpdate = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        remoteSynchronisationToUpdate.setOwner(null);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void changeSyncAdditionalJQL(long syncId, String additionalJQL) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        JiraRemoteSynchronisation jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation);
        if (!jiraRemoteSynchronisation.isBoard()) {
            return;
        }
        jiraRemoteSynchronisation.setAdditionalJQL(additionalJQL);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void changeSyncSprintAdditionalJQL(long syncId, String sprintAdditionalJQL) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        JiraRemoteSynchronisation jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation);
        if (!jiraRemoteSynchronisation.isBoard() || !jiraRemoteSynchronisation.isSprintSynchronisationEnable()) {
            return;
        }
        jiraRemoteSynchronisation.setSprintAdditionalJQL(sprintAdditionalJQL);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeJiraStatusField(long projectId, String jiraStatusField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setStatusField(jiraStatusField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeJiraRedactionField(long projectId, String jiraRedactionField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setRedactionProgressField(jiraRedactionField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeJiraRedactionRatioField(long projectId, String jiraRedactionRatioField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setRedactionRatioField(jiraRedactionRatioField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeJiraVerificationField(long projectId, String jiraVerificationField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setVerificationProgressField(jiraVerificationField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeJiraVerificationRatioField(long projectId, String jiraVerificationRatioField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setVerificationRatioField(jiraVerificationRatioField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeJiraValidationField(long projectId, String jiraValidationField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setValidationProgressField(jiraValidationField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeJiraValidationRatioField(long projectId, String jiraValidationRatioField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setValidationRatioField(jiraValidationRatioField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void commandFullSynchronisation(long syncId) {
        this.commandFullSynchronisationUnsecured(syncId);
    }

    private void commandFullSynchronisationUnsecured(long syncId) {
        LOGGER.info("[JIRA-SYNC] : Command given to perform full synchronisation on {}", (Object)syncId);
        this.requirementSyncExtenderDao.resetRemoteLastUpdated(Long.valueOf(syncId));
    }

    @PreAuthorize(value="hasPermission(#targetProjectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void synchronizeTemplateConfiguration(Long templateId, Long targetProjectId) {
        Configuration conf = this.dao.getConfigurationForProject(templateId);
        if (conf != null) {
            this.dao.storeConfigurationForProject(targetProjectId, conf);
            this.commandFullSynchronisationForProject(targetProjectId);
        } else {
            LOGGER.info("[JIRA-SYNC] : No configuration to copy from template {} to project {}", (Object)targetProjectId, (Object)targetProjectId);
        }
    }

    private void commandFullSynchronisationForProject(Long projectId) {
        LOGGER.info("[JIRA-SYNC] : Forcing all synchronisations for {}", (Object)projectId);
        List<JiraRemoteSynchronisation> jiraRemoteSynchronisations = this.findRemoteSyncForProject(projectId, "squash.tm.plugin.jirasync");
        jiraRemoteSynchronisations.forEach(jiraRemoteSynchronisation -> this.commandFullSynchronisationUnsecured(jiraRemoteSynchronisation.getId()));
    }

    public CredentialStatusDto getCredentialsStatus(Long serverId) {
        BugTracker bugTracker = (BugTracker)this.entityManager.find(BugTracker.class, (Object)serverId);
        return this.clientProvider.getCredentialsStatus(bugTracker);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void deleteSprintSync(long syncId) {
        RemoteSynchronisation currentSync = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        if (Objects.isNull(currentSync)) {
            return;
        }
        JiraRemoteSynchronisation jiraCurrentRemoteSynchro = new JiraRemoteSynchronisation(currentSync);
        jiraCurrentRemoteSynchro.removeSprintSynchronisation();
        this.entityManager.persist((Object)jiraCurrentRemoteSynchro.getRemoteSynchronisation());
        this.customGenericProjectManager.removeSprintSynchronisationBySyncIds(Collections.singletonList(syncId));
    }

    public JiraRemoteSynchronisation updateSynchronizationFromModel(JiraRemoteSynchronisationModel syncUpdateModel) {
        this.checkPermissionOnSyncIds(Collections.singletonList(syncUpdateModel.getId()));
        return this.handleUpdate(syncUpdateModel, UPDATE_SYNC);
    }

    public JiraRemoteSynchronisation createSprintSynchronisationWithoutValidation(JiraRemoteSynchronisation jiraRemoteSynchronisation, JiraRemoteSynchronisationModel syncUpdateModel) {
        this.checkPermissionOnSyncIds(Collections.singletonList(jiraRemoteSynchronisation.getId()));
        this.createSprintSynchroWithModelValues(jiraRemoteSynchronisation, syncUpdateModel);
        this.entityManager.persist((Object)jiraRemoteSynchronisation.getRemoteSynchronisation());
        return jiraRemoteSynchronisation;
    }

    public JiraRemoteSynchronisation createSprintSynchronisation(JiraRemoteSynchronisationModel syncUpdateModel) {
        this.checkPermissionOnSyncIds(Collections.singletonList(syncUpdateModel.getId()));
        return this.handleUpdate(syncUpdateModel, CREATE_SPRINT_SYNC);
    }

    private JiraRemoteSynchronisation handleUpdate(JiraRemoteSynchronisationModel syncUpdateModel, String action) {
        syncUpdateModel.cleanPaths();
        RemoteSynchronisation currentSync = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncUpdateModel.getId());
        JiraRemoteSynchronisation jiraCurrentRemoteSynchro = new JiraRemoteSynchronisation(currentSync);
        switch (action) {
            case "updateSync": {
                this.updateSynchroWithModelValues(jiraCurrentRemoteSynchro, syncUpdateModel);
                break;
            }
            case "createSprintSync": {
                this.remoteSynchronisationService.validatePathForSprintSync(currentSync.getProject().getName(), syncUpdateModel.getSprintSynchronisationPath());
                this.createSprintSynchroWithModelValues(jiraCurrentRemoteSynchro, syncUpdateModel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for action: " + action);
            }
        }
        this.entityManager.persist((Object)jiraCurrentRemoteSynchro.getRemoteSynchronisation());
        return jiraCurrentRemoteSynchro;
    }

    private void updateSynchroWithModelValues(JiraRemoteSynchronisation jiraCurrentRemoteSynchro, JiraRemoteSynchronisationModel syncUpdateModel) {
        String newSprintAdditionalJQL;
        String newAdditionalJQL;
        String newSelectValue = syncUpdateModel.getSelectValue();
        if (newSelectValue != null) {
            jiraCurrentRemoteSynchro.setSelectValue(newSelectValue);
        }
        if ((newAdditionalJQL = syncUpdateModel.getAdditionalJQL()) != null) {
            jiraCurrentRemoteSynchro.setAdditionalJQL(newAdditionalJQL);
        }
        if ((newSprintAdditionalJQL = syncUpdateModel.getSprintAdditionalJQL()) != null) {
            jiraCurrentRemoteSynchro.setSprintAdditionalJQL(newSprintAdditionalJQL);
        }
    }

    private void createSprintSynchroWithModelValues(JiraRemoteSynchronisation jiraCurrentRemoteSynchro, JiraRemoteSynchronisationModel syncUpdateModel) {
        String newSprintSynchronisationPath = syncUpdateModel.getSprintSynchronisationPath();
        if (newSprintSynchronisationPath != null && !"".equals(newSprintSynchronisationPath)) {
            jiraCurrentRemoteSynchro.setSprintSynchronisationPath(newSprintSynchronisationPath);
            String newSprintAdditionalJQL = syncUpdateModel.getSprintAdditionalJQL();
            if (newSprintAdditionalJQL != null) {
                jiraCurrentRemoteSynchro.setSprintAdditionalJQL(newSprintAdditionalJQL);
            }
        } else {
            throw new PathValidationDomainException(SPRINT_SYNC_PATH_FIELD);
        }
        jiraCurrentRemoteSynchro.sprintRestrictedToActiveSprint(syncUpdateModel.isSprintRestrictedToActiveSprint());
        jiraCurrentRemoteSynchro.sprintSynchronisationEnable(true);
        this.checkIfMaxNumberOfIssuesInPerimeterExceeded(jiraCurrentRemoteSynchro, true);
    }

    private void checkPermissionOnSyncIds(List<Long> syncIds) {
        this.permissionEvaluationService.checkPermission(syncIds, Permissions.MANAGE_PROJECT.name(), RemoteSynchronisation.class.getName());
    }

    private void throwLocalePluginValidationException(String key) {
        throw new LocalePluginValidationException(this.inHelper.internationalize(key, LocaleContextHolder.getLocale()));
    }
}

